/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.MACAddress;
import com.cisco.pt.UUID;
import java.util.List;

public abstract class IPCParameter {
    public abstract void encode(EncodedBuffer var1);

    public static class VoidParameter
    extends IPCParameter {
        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)0);
        }
    }

    public static class UUIDParameter
    extends IPCParameter {
        protected UUID value;

        public UUIDParameter(UUID value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)13);
            buff.putUUID(this.value);
        }
    }

    public static class StringParameter
    extends IPCParameter {
        protected String value;

        public StringParameter(String value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)8);
            buff.putString(this.value);
        }
    }

    public static class ShortParameter
    extends IPCParameter {
        protected short value;

        public ShortParameter(short value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)3);
            buff.putShort(this.value);
        }
    }

    public static class QStringParameter
    extends IPCParameter {
        protected String value;

        public QStringParameter(String value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)9);
            buff.putString(this.value);
        }
    }

    public static class MACAddressParameter
    extends IPCParameter {
        protected MACAddress value;

        public MACAddressParameter(MACAddress value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)12);
            buff.putMACAddress(this.value);
        }
    }

    public static class LongParameter
    extends IPCParameter {
        protected long value;

        public LongParameter(long value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)5);
            buff.putLong(this.value);
        }
    }

    public static class IPV6AddressParameter
    extends IPCParameter {
        protected IPV6Address value;

        public IPV6AddressParameter(IPV6Address value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)11);
            buff.putIPV6Address(this.value);
        }
    }

    public static class IPAddressParameter
    extends IPCParameter {
        protected IPAddress value;

        public IPAddressParameter(IPAddress value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)10);
            buff.putIPAddress(this.value);
        }
    }

    public static class IntParameter
    extends IPCParameter {
        protected int value;

        public IntParameter(int value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)4);
            buff.putInt(this.value);
        }
    }

    public static class FloatParameter
    extends IPCParameter {
        protected float value;

        public FloatParameter(float value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)6);
            buff.putFloat(this.value);
        }
    }

    public static class DoubleParameter
    extends IPCParameter {
        protected double value;

        public DoubleParameter(double value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)7);
            buff.putDouble(this.value);
        }
    }

    public static class ByteListParameter
    extends IPCParameter {
        protected List<Byte> value;

        public ByteListParameter(List<Byte> value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByteList(this.value);
        }
    }

    public static class ByteParameter
    extends IPCParameter {
        protected byte value;

        public ByteParameter(byte value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)1);
            buff.putByte(this.value);
        }
    }

    public static class BoolParameter
    extends IPCParameter {
        protected boolean value;

        public BoolParameter(boolean value) {
            this.value = value;
        }

        @Override
        public void encode(EncodedBuffer buff) {
            buff.putByte((byte)2);
            buff.putBool(this.value);
        }
    }
}

