/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.impl.LTVParsingError;
import com.cisco.pt.ipc.IPCData;
import com.cisco.pt.ipc.impl.IPCDataImpl;
import com.cisco.pt.ipc.sim.impl.ACLStatementImpl;
import com.cisco.pt.ipc.sim.impl.ARPEntryImpl;
import com.cisco.pt.ipc.sim.impl.ARPRequestImpl;
import com.cisco.pt.ipc.sim.impl.ARPTableImpl;
import com.cisco.pt.ipc.sim.impl.BluetoothDeviceImpl;
import com.cisco.pt.ipc.sim.impl.BootSystemEntryImpl;
import com.cisco.pt.ipc.sim.impl.CDPNeighborImpl;
import com.cisco.pt.ipc.sim.impl.CloudSubLinkImpl;
import com.cisco.pt.ipc.sim.impl.CommandHistoryImpl;
import com.cisco.pt.ipc.sim.impl.CommandPrivilegeImpl;
import com.cisco.pt.ipc.sim.impl.DHCPPoolLeaseImpl;
import com.cisco.pt.ipc.sim.impl.DLCITableImpl;
import com.cisco.pt.ipc.sim.impl.EIGRPNeighborImpl;
import com.cisco.pt.ipc.sim.impl.EIGRPRoutingEntryImpl;
import com.cisco.pt.ipc.sim.impl.EIGRPSummaryAddressImpl;
import com.cisco.pt.ipc.sim.impl.EIGRPTopologyEntryImpl;
import com.cisco.pt.ipc.sim.impl.EIGRPTopologyTableImpl;
import com.cisco.pt.ipc.sim.impl.ExtNatEntryImpl;
import com.cisco.pt.ipc.sim.impl.ExtNatv6EntryImpl;
import com.cisco.pt.ipc.sim.impl.FlowChartNodeImpl;
import com.cisco.pt.ipc.sim.impl.FrameDecisionImpl;
import com.cisco.pt.ipc.sim.impl.FrameRelayMapEntryImpl;
import com.cisco.pt.ipc.sim.impl.IPV6AddressConfigImpl;
import com.cisco.pt.ipc.sim.impl.L2NatEntryImpl;
import com.cisco.pt.ipc.sim.impl.L2NatTableImpl;
import com.cisco.pt.ipc.sim.impl.MACEntryImpl;
import com.cisco.pt.ipc.sim.impl.MACTableImpl;
import com.cisco.pt.ipc.sim.impl.NATConfigEntryImpl;
import com.cisco.pt.ipc.sim.impl.NATEntryImpl;
import com.cisco.pt.ipc.sim.impl.NATListImpl;
import com.cisco.pt.ipc.sim.impl.NATListInterfaceImpl;
import com.cisco.pt.ipc.sim.impl.NATListPoolImpl;
import com.cisco.pt.ipc.sim.impl.NATPoolImpl;
import com.cisco.pt.ipc.sim.impl.NATTableImpl;
import com.cisco.pt.ipc.sim.impl.NATv6EntryImpl;
import com.cisco.pt.ipc.sim.impl.NATv6ListImpl;
import com.cisco.pt.ipc.sim.impl.NATv6ListInterfaceImpl;
import com.cisco.pt.ipc.sim.impl.NATv6ListPoolImpl;
import com.cisco.pt.ipc.sim.impl.NATv6PoolImpl;
import com.cisco.pt.ipc.sim.impl.NATv6TableImpl;
import com.cisco.pt.ipc.sim.impl.NdRoutingEntryImpl;
import com.cisco.pt.ipc.sim.impl.OSPFAreaNetworkImpl;
import com.cisco.pt.ipc.sim.impl.OSPFDatabaseImpl;
import com.cisco.pt.ipc.sim.impl.OSPFNeighborImpl;
import com.cisco.pt.ipc.sim.impl.OSPFRoutingEntryImpl;
import com.cisco.pt.ipc.sim.impl.RIPRoutingEntryImpl;
import com.cisco.pt.ipc.sim.impl.RoutingEntryImpl;
import com.cisco.pt.ipc.sim.impl.RoutingNetworkImpl;
import com.cisco.pt.ipc.sim.impl.RoutingTableImpl;
import com.cisco.pt.ipc.sim.impl.StaticMacImpl;
import com.cisco.pt.ipc.sim.impl.StaticRouteImpl;
import com.cisco.pt.ipc.sim.impl.TimedAsExternalLSAImpl;
import com.cisco.pt.ipc.sim.impl.TimedNetworkLSAImpl;
import com.cisco.pt.ipc.sim.impl.TimedRouterLSAImpl;
import com.cisco.pt.ipc.sim.impl.TimedSummaryLSAImpl;
import com.cisco.pt.ipc.sim.impl.TimedType7LSAImpl;
import com.cisco.pt.ipc.sim.impl.UserDesktopAppCliConfigImpl;
import com.cisco.pt.ipc.sim.impl.WirelessProfileImpl;
import com.cisco.pt.ipc.sim.pdu.impl.ARPPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.ASAFileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.AhHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.AnalogPhoneSignalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.AuthPayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpAttribASPathImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpAttribAtomicAggImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpAttribLocalPrefImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpAttribMedImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpAttribNextHopImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpAttribOriginImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpAttributeImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpKeepAliveImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpNotificationImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpOpenImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpPathSegmentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpPrefixImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BgpUpdateImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BluetoothDataImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BluetoothFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BluetoothManagementSignalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.BnepHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPAddressImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPAddressPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPCapabilityImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPCoSImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPDeviceIdImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPNativeVlanImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPPlatformImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPPortIdImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPSoftwareVersionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPTypeLengthValueImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CDPVoipVlanImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CHAPPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CapwapControlMessageElementImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CapwapControlMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CapwapUdpPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CellularHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CustomIOPduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.CustomPduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPOptionClientIdentifierImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPOptionDomainNameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPOptionDomainNameServerImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPOptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPOptionVendorSpecificImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPSubOptionCircuitIdImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPSubOptionRemoteIdImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6DUIDLLImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6HeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionClientServerIdImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionDNSImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionDomainSearchImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionElapsedTimeImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionIAAddressImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionIANAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionIAPrefixDelegationImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionIAPrefixImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionRequestImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6OptionStatusCodeImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DHCPv6PacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DLCIInfoImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSRAOptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSResourceRecordImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSRrAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSRrAv6Impl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSRrCnameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSRrNsImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DNSRrSoaImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DTPFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.DialFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.Dot1qHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPExternalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPInternalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPParametersImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPSoftwareVersionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPTlvImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPv6ExternalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPv6InternalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EIGRPv6PacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EapPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EapolPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EchoMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EspHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EthernetHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.EthernetIIHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FTPCommandPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FTPDataPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FTPPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FTPResponsePacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectByteCountImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectDestinationMaskImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectInterfaceImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectNextHopImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectPacketCountImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectRoutingAsImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectSourceMaskImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectStatementImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectSysUpFirstImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectSysUpLastImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowCollectTcpFlagsImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchDestinationAddrImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchExtensionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchFlowDirectionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchFlowLabelImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchFlowSamplerImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchInterfaceImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchProtocolImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchSourceAddrImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchStatementImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchTosImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowMatchTransportImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FlowRecordImpl;
import com.cisco.pt.ipc.sim.pdu.impl.FrameRelayHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.GreHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.H323MessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HFLFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPHeaderPairImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPPageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPPostImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPRequestHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPRequestImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPResponseHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPResponseImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HTTPsResponseImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HdlcFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.HsrpMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.Hsrpv6MessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.ICMPMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.ICMPv6MessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IEEE802Dot3HeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IEEE802Dot3zHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IPCPFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IPCPv6FrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IPHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IPV6FragmentExtensionHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IPV6HeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IPV6NextHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IdPayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IkePayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IkePduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.InvArpFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IoePduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IosBundleFileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IosFileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.IoxClientConfigFileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.JamSignalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LLCHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LMIFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LSLFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LacpFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LcpFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LinkLayerOptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LinksysConfigInfoPageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LinksysConfigPageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LinksysFirmwareUpgPageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTLVImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_ChassisIDImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_OrgSpecificImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_PortDescriptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_PortIDImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_SystemCapabilitiesImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_SystemDescriptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_SystemNameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LldpTlv_TimeToLiveImpl;
import com.cisco.pt.ipc.sim.pdu.impl.LwappUdpPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.MailImpl;
import com.cisco.pt.ipc.sim.pdu.impl.ManagementFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.MerakiUdpPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.MtuOptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NFExporterPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NFExporterPacketv9Impl;
import com.cisco.pt.ipc.sim.pdu.impl.NFFlowImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NFFlowSetImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NFHeaderv9Impl;
import com.cisco.pt.ipc.sim.pdu.impl.NFTemplateImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NdMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NdOptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NeighborMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NotificationPayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.NtpHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFAsExternalLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFDDPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFHelloPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFLSAHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFLSAckPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFLSRImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFLSRPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFLSUPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFNetworkLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFRouterLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFRouterLinkImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFSummaryLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFType7LSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv3DDPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv3HelloPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6AsExternalLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6InterAreaPrefixLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6InterAreaRouterLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6IntraAreaPrefixLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6LSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6LinkLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6NetworkLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6OptionFieldImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6PrefixImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6RouterInterfaceImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6RouterLSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6Type7LSAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.OvaFileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PPPFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PPPoeHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PTPPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PaasFileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PacketTooBigMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PagpFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PapPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PduGroupImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.Pop3HeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.PrefixOptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.ProposalPayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RIPPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RIPRoutePacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RIPv6PacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RIPv6RoutePacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RadiusPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RepTLVImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RepTLV_BPAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RepTLV_EPAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RepTLV_ElectionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RepTLV_PAImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RouterAdvertisementMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RouterSolicitationMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RstpFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.RtpMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.STPFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.STPIdImpl;
import com.cisco.pt.ipc.sim.pdu.impl.STPTypeLengthValueImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SaPayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SccpMessageImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SegmentHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SignalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SlarpDataImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SmtpHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SnapLLCHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SnmpHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SnmpPduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SshAuthPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SshPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.SyslogEntryImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TFTPDataImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TFTPErrorImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TFTPHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TFTPRequestImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TFTPResponseImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TacacsPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TcpHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TcpOptionImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TcpOptionMSSImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TelnetPacketImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TextFileContentImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TransformPayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TvDataImpl;
import com.cisco.pt.ipc.sim.pdu.impl.TvHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.UdpHeaderImpl;
import com.cisco.pt.ipc.sim.pdu.impl.UsbDataImpl;
import com.cisco.pt.ipc.sim.pdu.impl.UsbDebugDataImpl;
import com.cisco.pt.ipc.sim.pdu.impl.UsbDeployPduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.UsbFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.UsbManagementSignalImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VTPFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VTPRequestFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VTPSubsetFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VTPSummaryFrameImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VTPVlanInfoImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VarBindingsImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VariableSizePduImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VendorIdPayloadImpl;
import com.cisco.pt.ipc.sim.pdu.impl.VoiceDataImpl;
import com.cisco.pt.ipc.sim.pdu.impl.WLCSyslogEntryImpl;
import com.cisco.pt.ipc.sim.pdu.impl.WirelessHeaderImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPCResponseFactory {
    private static Log logger = LogFactory.getLog(IPCResponseFactory.class);

    public static IPCResponseLTV parseIPCResponseLTV(EncodedBuffer buff) {
        int messageId = buff.getInt();
        IPCResponseLTV responseLTV = new IPCResponseLTV(messageId);
        if (buff.remaining() == 0) {
            return responseLTV;
        }
        responseLTV.setValue(IPCResponseFactory.getResponseData(buff));
        return responseLTV;
    }

    public static Object getResponseData(EncodedBuffer buff) {
        byte type = buff.getByte();
        return IPCResponseFactory.getResponseData(buff, type);
    }

    public static Object getResponseData(EncodedBuffer buff, byte type) {
        return IPCResponseFactory.getResponseData(buff, type, false);
    }

    public static Object getResponseData(EncodedBuffer buff, byte type, boolean inVector) {
        switch (type) {
            case 2: {
                return new Boolean(buff.getBool());
            }
            case 1: {
                return new Byte(inVector ? buff.getByteRaw() : buff.getByte());
            }
            case 16: {
                return IPCResponseFactory.getIPCData(buff);
            }
            case 7: {
                return new Double(buff.getDouble());
            }
            case 6: {
                return new Float(buff.getFloat());
            }
            case 4: {
                return new Integer(buff.getInt());
            }
            case 10: {
                return buff.getIPAddress();
            }
            case 11: {
                return buff.getIPV6Address();
            }
            case 5: {
                return new Long(buff.getLong());
            }
            case 12: {
                return buff.getMACAddress();
            }
            case 14: {
                return IPCResponseFactory.getPairData(buff);
            }
            case 3: {
                return new Short(buff.getShort());
            }
            case 8: 
            case 9: {
                return buff.getString();
            }
            case 13: {
                return buff.getUUID();
            }
            case 15: {
                return IPCResponseFactory.getVectorData(buff);
            }
            case 0: {
                return null;
            }
        }
        throw new LTVParsingError("Unhandled type for IPCReturnLTV: " + type);
    }

    public static Object getPduResponseData(EncodedBuffer buff, byte type, boolean inVector) {
        switch (type) {
            case 2: {
                return new Boolean(buff.getBool());
            }
            case 1: {
                return new Byte(inVector ? buff.getByteRaw() : buff.getByte());
            }
            case 16: {
                return IPCResponseFactory.getPDUData(buff);
            }
            case 7: {
                return new Double(buff.getDouble());
            }
            case 6: {
                return new Float(buff.getFloat());
            }
            case 4: {
                return new Integer(buff.getInt());
            }
            case 10: {
                return buff.getIPAddress();
            }
            case 11: {
                return buff.getIPV6Address();
            }
            case 5: {
                return new Long(buff.getLong());
            }
            case 12: {
                return buff.getMACAddress();
            }
            case 14: {
                return IPCResponseFactory.getPairData(buff);
            }
            case 3: {
                return new Short(buff.getShort());
            }
            case 8: 
            case 9: {
                return buff.getString();
            }
            case 13: {
                return buff.getUUID();
            }
            case 15: {
                return IPCResponseFactory.getPDUVectorData(buff, type);
            }
            case 0: {
                return null;
            }
        }
        throw new LTVParsingError("Unhandled type for IPCReturnLTV: " + type);
    }

    public static Pair<Object, Object> getPairData(EncodedBuffer buff) {
        Object firstData = IPCResponseFactory.getResponseData(buff);
        Object secondData = IPCResponseFactory.getResponseData(buff);
        return new Pair<Object, Object>(firstData, secondData);
    }

    public static List<Object> getPduVectorData(EncodedBuffer buff, byte subType) {
        int length = buff.getInt();
        ArrayList<Object> answer = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            answer.add(IPCResponseFactory.getPduResponseData(buff, subType, true));
        }
        return answer;
    }

    public static List<Object> getVectorData(EncodedBuffer buff) {
        byte subType = buff.getByte();
        int length = buff.getInt();
        ArrayList<Object> answer = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            answer.add(IPCResponseFactory.getResponseData(buff, subType, true));
        }
        return answer;
    }

    public static List<Object> getPDUVectorData(EncodedBuffer buff, byte subType) {
        int length = buff.getInt();
        ArrayList<Object> answer = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            answer.add(IPCResponseFactory.getPduResponseData(buff, subType, true));
        }
        return answer;
    }

    public static List<Object> getParameterList(EncodedBuffer buff) {
        ArrayList<Object> answer = new ArrayList<Object>();
        Object data = IPCResponseFactory.getResponseData(buff);
        while (data != null) {
            answer.add(data);
            data = IPCResponseFactory.getResponseData(buff);
        }
        return answer;
    }

    public static IPCData getIPCData(EncodedBuffer buff) {
        String subType = buff.peekString();
        IPCDataImpl data = null;
        try {
            if (subType.equalsIgnoreCase("AclStatement")) {
                data = new ACLStatementImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("ArpEntry")) {
                data = new ARPEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("ArpRequest")) {
                data = new ARPRequestImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("ArpTable")) {
                data = new ARPTableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("BluetoothDevice")) {
                data = new BluetoothDeviceImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("BootSystemEntry")) {
                data = new BootSystemEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("CdpNeighbor")) {
                data = new CDPNeighborImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("CloudSubLink")) {
                data = new CloudSubLinkImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("CommandHistory")) {
                data = new CommandHistoryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("CommandPrivilege")) {
                data = new CommandPrivilegeImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("DhcpPoolLease")) {
                data = new DHCPPoolLeaseImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("DlciTable")) {
                data = new DLCITableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("EigrpNeighbor")) {
                data = new EIGRPNeighborImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("EigrpRoutingEntry")) {
                data = new EIGRPRoutingEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("EigrpSummaryAddress")) {
                data = new EIGRPSummaryAddressImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("EigrpTopologyEntry")) {
                data = new EIGRPTopologyEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("EigrpTopologyTable")) {
                data = new EIGRPTopologyTableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("ExtNatEntry")) {
                data = new ExtNatEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("ExtNatv6Entry")) {
                data = new ExtNatv6EntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("FlowChartNode")) {
                data = new FlowChartNodeImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("FrameDecision")) {
                data = new FrameDecisionImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("FrameRelayMapEntry")) {
                data = new FrameRelayMapEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("Ipv6AddressConfig")) {
                data = new IPV6AddressConfigImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("L2NatEntry")) {
                data = new L2NatEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("L2NatTable")) {
                data = new L2NatTableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("MacEntry")) {
                data = new MACEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("MacTable")) {
                data = new MACTableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NatConfigEntry")) {
                data = new NATConfigEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NatEntry")) {
                data = new NATEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NatListInterface")) {
                data = new NATListInterfaceImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NatList")) {
                data = new NATListImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NatListPool")) {
                data = new NATListPoolImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NatPool")) {
                data = new NATPoolImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NatTable")) {
                data = new NATTableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("Natv6Entry")) {
                data = new NATv6EntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("Natv6ListInterface")) {
                data = new NATv6ListInterfaceImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("Natv6List")) {
                data = new NATv6ListImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("Natv6ListPool")) {
                data = new NATv6ListPoolImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("Natv6Pool")) {
                data = new NATv6PoolImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("Natv6Table")) {
                data = new NATv6TableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("NdRoutingEntry")) {
                data = new NdRoutingEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("OspfAreaNetwork")) {
                data = new OSPFAreaNetworkImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("OspfDatabase")) {
                data = new OSPFDatabaseImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("OspfNeighbor")) {
                data = new OSPFNeighborImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("OspfRoutingEntry")) {
                data = new OSPFRoutingEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("RipRoutingEntry")) {
                data = new RIPRoutingEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("RoutingEntry")) {
                data = new RoutingEntryImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("RoutingNetwork")) {
                data = new RoutingNetworkImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("RoutingTable")) {
                data = new RoutingTableImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("StaticMac")) {
                data = new StaticMacImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("StaticRoute")) {
                data = new StaticRouteImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("TimedAsExternalLSA")) {
                data = new TimedAsExternalLSAImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("TimedNetworkLSA")) {
                data = new TimedNetworkLSAImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("TimedRouterLSA")) {
                data = new TimedRouterLSAImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("TimedSummaryLSA")) {
                data = new TimedSummaryLSAImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("TimedType7LSA")) {
                data = new TimedType7LSAImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("UserDesktopAppCliConfig")) {
                data = new UserDesktopAppCliConfigImpl();
                buff.getString();
                data.read(buff);
            } else if (subType.equalsIgnoreCase("WirelessProfile")) {
                data = new WirelessProfileImpl();
                buff.getString();
                data.read(buff);
            } else {
                buff.getString();
                return null;
            }
            return data;
        }
        catch (Throwable t) {
            System.err.println(subType + " " + t.toString());
            return null;
        }
    }

    public static IPCData getPDUData(EncodedBuffer buff) {
        String subType = buff.peekString();
        SignalImpl data = null;
        try {
            if (subType.equalsIgnoreCase("ArpPacket")) {
                data = new ARPPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("ASAFileContent")) {
                data = new ASAFileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("AhHeader")) {
                data = new AhHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CAnalogPhoneSignal")) {
                data = new AnalogPhoneSignalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("AuthPayload")) {
                data = new AuthPayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpAttribASPath")) {
                data = new BgpAttribASPathImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpAttribAtomicAgg")) {
                data = new BgpAttribAtomicAggImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpAttribLocalPref")) {
                data = new BgpAttribLocalPrefImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpAttribMed")) {
                data = new BgpAttribMedImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpAttribNextHop")) {
                data = new BgpAttribNextHopImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpAttribOrigin")) {
                data = new BgpAttribOriginImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpAttribute")) {
                data = new BgpAttributeImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpKeepAlive")) {
                data = new BgpKeepAliveImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpNotification")) {
                data = new BgpNotificationImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpOpen")) {
                data = new BgpOpenImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpPacket")) {
                data = new BgpPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpPathSegment")) {
                data = new BgpPathSegmentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpPrefix")) {
                data = new BgpPrefixImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BgpUpdate")) {
                data = new BgpUpdateImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BluetoothData")) {
                data = new BluetoothDataImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BluetoothFrame")) {
                data = new BluetoothFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BluetoothManagementSignal")) {
                data = new BluetoothManagementSignalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("BnepHeader")) {
                data = new BnepHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpAddress")) {
                data = new CDPAddressImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpAddressPacket")) {
                data = new CDPAddressPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpCapability")) {
                data = new CDPCapabilityImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpCoS")) {
                data = new CDPCoSImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpDeviceId")) {
                data = new CDPDeviceIdImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpFrame")) {
                data = new CDPFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpNativeVlan")) {
                data = new CDPNativeVlanImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpPlatform")) {
                data = new CDPPlatformImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpPortId")) {
                data = new CDPPortIdImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpSoftwareVersion")) {
                data = new CDPSoftwareVersionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpTypeLengthValue")) {
                data = new CDPTypeLengthValueImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CdpVoipVlan")) {
                data = new CDPVoipVlanImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("ChapPacket")) {
                data = new CHAPPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CapwapControlMessage")) {
                data = new CapwapControlMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CCapwapControlMessageElement")) {
                data = new CapwapControlMessageElementImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CapwapUdpPacket")) {
                data = new CapwapUdpPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CellularHeader")) {
                data = new CellularHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CustomIOPdu")) {
                data = new CustomIOPduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CustomPdu")) {
                data = new CustomPduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpOptionClientIdentifier")) {
                data = new DHCPOptionClientIdentifierImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpOption")) {
                data = new DHCPOptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpOptionDomainName")) {
                data = new DHCPOptionDomainNameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpOptionDomainNameServer")) {
                data = new DHCPOptionDomainNameServerImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpOptionVendorSpecific")) {
                data = new DHCPOptionVendorSpecificImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpPacket")) {
                data = new DHCPPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpSubOptionCircuitId")) {
                data = new DHCPSubOptionCircuitIdImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DhcpSubOptionRemoteId")) {
                data = new DHCPSubOptionRemoteIdImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6DUIDLL")) {
                data = new DHCPv6DUIDLLImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6Header")) {
                data = new DHCPv6HeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionClientServerId")) {
                data = new DHCPv6OptionClientServerIdImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionDNS")) {
                data = new DHCPv6OptionDNSImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6Option")) {
                data = new DHCPv6OptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionDomainSearch")) {
                data = new DHCPv6OptionDomainSearchImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionElapsedTime")) {
                data = new DHCPv6OptionElapsedTimeImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionIAAddress")) {
                data = new DHCPv6OptionIAAddressImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionIANA")) {
                data = new DHCPv6OptionIANAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionIAPrefixDelegation")) {
                data = new DHCPv6OptionIAPrefixDelegationImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionIAPrefix")) {
                data = new DHCPv6OptionIAPrefixImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionRequest")) {
                data = new DHCPv6OptionRequestImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dhcpv6OptionStatusCode")) {
                data = new DHCPv6OptionStatusCodeImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CDhcpv6Packet")) {
                data = new DHCPv6PacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DlciInfo")) {
                data = new DLCIInfoImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsHeader")) {
                data = new DNSHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsMessage")) {
                data = new DNSMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsRAOption")) {
                data = new DNSRAOptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsResourceRecord")) {
                data = new DNSResourceRecordImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsRrA")) {
                data = new DNSRrAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsRrAv6")) {
                data = new DNSRrAv6Impl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsRrCname")) {
                data = new DNSRrCnameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsRrNs")) {
                data = new DNSRrNsImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DnsRrSoa")) {
                data = new DNSRrSoaImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DtpFrame")) {
                data = new DTPFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("DialFrame")) {
                data = new DialFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Dot1qHeader")) {
                data = new Dot1qHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EigrpExternal")) {
                data = new EIGRPExternalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EigrpInternal")) {
                data = new EIGRPInternalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EigrpPacket")) {
                data = new EIGRPPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EigrpParameters")) {
                data = new EIGRPParametersImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("CEigrpSoftwareVersion")) {
                data = new EIGRPSoftwareVersionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EigrpTlv")) {
                data = new EIGRPTlvImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Eigrpv6External")) {
                data = new EIGRPv6ExternalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Eigrpv6Internal")) {
                data = new EIGRPv6InternalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Eigrpv6Packet")) {
                data = new EIGRPv6PacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EapPacket")) {
                data = new EapPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EapolPacket")) {
                data = new EapolPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EchoMessage")) {
                data = new EchoMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EspHeader")) {
                data = new EspHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EthernetHeader")) {
                data = new EthernetHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("EthernetIIHeader")) {
                data = new EthernetIIHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FtpCommandPacket")) {
                data = new FTPCommandPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FtpDataPacket")) {
                data = new FTPDataPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FtpPacket")) {
                data = new FTPPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FtpResponsePacket")) {
                data = new FTPResponsePacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FileContent")) {
                data = new FileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectByteCount")) {
                data = new FlowCollectByteCountImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectDestinationMask")) {
                data = new FlowCollectDestinationMaskImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectInterface")) {
                data = new FlowCollectInterfaceImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectNextHop")) {
                data = new FlowCollectNextHopImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectPacketCount")) {
                data = new FlowCollectPacketCountImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectRoutingAs")) {
                data = new FlowCollectRoutingAsImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectSourceMask")) {
                data = new FlowCollectSourceMaskImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectStatement")) {
                data = new FlowCollectStatementImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectSysUpFirst")) {
                data = new FlowCollectSysUpFirstImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectSysUpLast")) {
                data = new FlowCollectSysUpLastImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowCollectTcpFlags")) {
                data = new FlowCollectTcpFlagsImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchDestinationAddr")) {
                data = new FlowMatchDestinationAddrImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchExtension")) {
                data = new FlowMatchExtensionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchFlowDirection")) {
                data = new FlowMatchFlowDirectionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchFlowLabel")) {
                data = new FlowMatchFlowLabelImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchFlowSampler")) {
                data = new FlowMatchFlowSamplerImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchInterface")) {
                data = new FlowMatchInterfaceImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchProtocol")) {
                data = new FlowMatchProtocolImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchSourceAddr")) {
                data = new FlowMatchSourceAddrImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchStatement")) {
                data = new FlowMatchStatementImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchTos")) {
                data = new FlowMatchTosImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowMatchTransport")) {
                data = new FlowMatchTransportImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FlowRecord")) {
                data = new FlowRecordImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("FrameRelayHeader")) {
                data = new FrameRelayHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("GreHeader")) {
                data = new GreHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("H323Message")) {
                data = new H323MessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HFLFrame")) {
                data = new HFLFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpHeader")) {
                data = new HTTPHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpHeaderPair")) {
                data = new HTTPHeaderPairImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpPage")) {
                data = new HTTPPageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpPost")) {
                data = new HTTPPostImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpRequestHeader")) {
                data = new HTTPRequestHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpRequest")) {
                data = new HTTPRequestImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpResponseHeader")) {
                data = new HTTPResponseHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpResponse")) {
                data = new HTTPResponseImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HttpsResponse")) {
                data = new HTTPsResponseImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HdlcFrame")) {
                data = new HdlcFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Header")) {
                data = new HeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("HsrpMessage")) {
                data = new HsrpMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Hsrpv6Message")) {
                data = new Hsrpv6MessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IcmpMessage")) {
                data = new ICMPMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Icmpv6Message")) {
                data = new ICMPv6MessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IEEE802Dot3Header")) {
                data = new IEEE802Dot3HeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IEEE802Dot3zHeader")) {
                data = new IEEE802Dot3zHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IPCPFrame")) {
                data = new IPCPFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IPCPv6Frame")) {
                data = new IPCPv6FrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IpHeader")) {
                data = new IPHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ipv6FragmentExtensionHeader")) {
                data = new IPV6FragmentExtensionHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ipv6Header")) {
                data = new IPV6HeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ipv6NextHeader")) {
                data = new IPV6NextHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IdPayload")) {
                data = new IdPayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IkePayload")) {
                data = new IkePayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IkePdu")) {
                data = new IkePduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("InvArpFrame")) {
                data = new InvArpFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IoePdu")) {
                data = new IoePduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IosBundleFileContent")) {
                data = new IosBundleFileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IosFileContent")) {
                data = new IosFileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("IoxClientConfigFileContent")) {
                data = new IoxClientConfigFileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("JamSignal")) {
                data = new JamSignalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LLCHeader")) {
                data = new LLCHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LmiFrame")) {
                data = new LMIFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LSLFrame")) {
                data = new LSLFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LacpFrame")) {
                data = new LacpFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LcpFrame")) {
                data = new LcpFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LinkLayerOption")) {
                data = new LinkLayerOptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LinksysConfigInfoPage")) {
                data = new LinksysConfigInfoPageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LinksysConfigPage")) {
                data = new LinksysConfigPageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LinksysFirmwareUpgPage")) {
                data = new LinksysFirmwareUpgPageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpPacket")) {
                data = new LldpPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTLV")) {
                data = new LldpTLVImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_ChassisID")) {
                data = new LldpTlv_ChassisIDImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_OrgSpecific")) {
                data = new LldpTlv_OrgSpecificImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_PortDescription")) {
                data = new LldpTlv_PortDescriptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_PortID")) {
                data = new LldpTlv_PortIDImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_SystemCapabilities")) {
                data = new LldpTlv_SystemCapabilitiesImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_SystemDescription")) {
                data = new LldpTlv_SystemDescriptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_SystemName")) {
                data = new LldpTlv_SystemNameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LldpTlv_TimeToLive")) {
                data = new LldpTlv_TimeToLiveImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("LwappUdpPacket")) {
                data = new LwappUdpPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Mail")) {
                data = new MailImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("ManagementFrame")) {
                data = new ManagementFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("MerakiUdpPacket")) {
                data = new MerakiUdpPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("MtuOption")) {
                data = new MtuOptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NFExporterPacket")) {
                data = new NFExporterPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NFExporterPacketv9")) {
                data = new NFExporterPacketv9Impl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NFFlow")) {
                data = new NFFlowImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NFFlowSet")) {
                data = new NFFlowSetImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NFHeaderv9")) {
                data = new NFHeaderv9Impl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NFTemplate")) {
                data = new NFTemplateImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NdMessage")) {
                data = new NdMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NdOption")) {
                data = new NdOptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NeighborMessage")) {
                data = new NeighborMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NotificationPayload")) {
                data = new NotificationPayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("NtpHeader")) {
                data = new NtpHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfAsExternalLSA")) {
                data = new OSPFAsExternalLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfDDPacket")) {
                data = new OSPFDDPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfHelloPacket")) {
                data = new OSPFHelloPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfLSAHeader")) {
                data = new OSPFLSAHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfLSA")) {
                data = new OSPFLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfLSAckPacket")) {
                data = new OSPFLSAckPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfLSR")) {
                data = new OSPFLSRImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfLSRPacket")) {
                data = new OSPFLSRPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfLSUPacket")) {
                data = new OSPFLSUPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfNetworkLSA")) {
                data = new OSPFNetworkLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfPacket")) {
                data = new OSPFPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfRouterLSA")) {
                data = new OSPFRouterLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfRouterLink")) {
                data = new OSPFRouterLinkImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfSummaryLSA")) {
                data = new OSPFSummaryLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OspfType7LSA")) {
                data = new OSPFType7LSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv3DDPacket")) {
                data = new OSPFv3DDPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv3HelloPacket")) {
                data = new OSPFv3HelloPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6AsExternalLSA")) {
                data = new OSPFv6AsExternalLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6InterAreaPrefixLSA")) {
                data = new OSPFv6InterAreaPrefixLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6InterAreaRouterLSA")) {
                data = new OSPFv6InterAreaRouterLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6IntraAreaPrefixLSA")) {
                data = new OSPFv6IntraAreaPrefixLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6LSA")) {
                data = new OSPFv6LSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6LinkLSA")) {
                data = new OSPFv6LinkLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6NetworkLSA")) {
                data = new OSPFv6NetworkLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6OptionField")) {
                data = new OSPFv6OptionFieldImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6Prefix")) {
                data = new OSPFv6PrefixImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6RouterInterface")) {
                data = new OSPFv6RouterInterfaceImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6RouterLSA")) {
                data = new OSPFv6RouterLSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ospfv6Type7LSA")) {
                data = new OSPFv6Type7LSAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("OvaFileContent")) {
                data = new OvaFileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PppFrame")) {
                data = new PPPFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PppoeHeader")) {
                data = new PPPoeHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PTPPacket")) {
                data = new PTPPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PaasFileContent")) {
                data = new PaasFileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PacketTooBigMessage")) {
                data = new PacketTooBigMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PagpFrame")) {
                data = new PagpFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PapPacket")) {
                data = new PapPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PduGroup")) {
                data = new PduGroupImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Pdu")) {
                data = new PduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Pop3Header")) {
                data = new Pop3HeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("PrefixOption")) {
                data = new PrefixOptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("ProposalPayload")) {
                data = new ProposalPayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RipPacket")) {
                data = new RIPPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RipRoutePacket")) {
                data = new RIPRoutePacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ripv6Packet")) {
                data = new RIPv6PacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Ripv6RoutePacket")) {
                data = new RIPv6RoutePacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RadiusPacket")) {
                data = new RadiusPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RepTLV")) {
                data = new RepTLVImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RepTLV_BPA")) {
                data = new RepTLV_BPAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RepTLV_EPA")) {
                data = new RepTLV_EPAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RepTLV_Election")) {
                data = new RepTLV_ElectionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RepTLV_PA")) {
                data = new RepTLV_PAImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RouterAdvertisementMessage")) {
                data = new RouterAdvertisementMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RouterSolicitationMessage")) {
                data = new RouterSolicitationMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RstpFrame")) {
                data = new RstpFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("RtpMessage")) {
                data = new RtpMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("StpFrame")) {
                data = new STPFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("StpId")) {
                data = new STPIdImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("StpTypeLengthValue")) {
                data = new STPTypeLengthValueImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SaPayload")) {
                data = new SaPayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SccpMessage")) {
                data = new SccpMessageImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SegmentHeader")) {
                data = new SegmentHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("Signal")) {
                data = new SignalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SlarpData")) {
                data = new SlarpDataImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SmtpHeader")) {
                data = new SmtpHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SnapLLCHeader")) {
                data = new SnapLLCHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SnmpHeader")) {
                data = new SnmpHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SnmpPdu")) {
                data = new SnmpPduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SshAuthPacket")) {
                data = new SshAuthPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SshPacket")) {
                data = new SshPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("SyslogEntry")) {
                data = new SyslogEntryImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TftpData")) {
                data = new TFTPDataImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TftpError")) {
                data = new TFTPErrorImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TftpHeader")) {
                data = new TFTPHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TftpRequest")) {
                data = new TFTPRequestImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TftpResponse")) {
                data = new TFTPResponseImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TacacsPacket")) {
                data = new TacacsPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TcpHeader")) {
                data = new TcpHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TcpOptionMSS")) {
                data = new TcpOptionMSSImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TcpOption")) {
                data = new TcpOptionImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TelnetPacket")) {
                data = new TelnetPacketImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TextFileContent")) {
                data = new TextFileContentImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TransformPayload")) {
                data = new TransformPayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TvData")) {
                data = new TvDataImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("TvHeader")) {
                data = new TvHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("UdpHeader")) {
                data = new UdpHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("UsbData")) {
                data = new UsbDataImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("UsbDebugData")) {
                data = new UsbDebugDataImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("UsbDeployPdu")) {
                data = new UsbDeployPduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("UsbFrame")) {
                data = new UsbFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("UsbManagementSignal")) {
                data = new UsbManagementSignalImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VtpFrame")) {
                data = new VTPFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VtpRequestFrame")) {
                data = new VTPRequestFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VtpSubsetFrame")) {
                data = new VTPSubsetFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VtpSummaryFrame")) {
                data = new VTPSummaryFrameImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VtpVlanInfo")) {
                data = new VTPVlanInfoImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VarBindings")) {
                data = new VarBindingsImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VariableSizePdu")) {
                data = new VariableSizePduImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VendorIdPayload")) {
                data = new VendorIdPayloadImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("VoiceData")) {
                data = new VoiceDataImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("WLCSyslogEntry")) {
                data = new WLCSyslogEntryImpl();
                buff.getString();
                data.pduRead(buff);
            } else if (subType.equalsIgnoreCase("WirelessHeader")) {
                data = new WirelessHeaderImpl();
                buff.getString();
                data.pduRead(buff);
            } else {
                buff.getString();
                return null;
            }
            return data;
        }
        catch (Throwable t) {
            System.err.println(subType + " " + t.toString());
            return null;
        }
    }
}

