/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;
import java.util.List;

public abstract class AppWindowEvent
extends IPCEvent {
    public EventType type;

    public AppWindowEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        FILE_NEWED,
        FILE_OPENED,
        ACTIVITY_FILE_OPENING,
        FILE_CLOSING,
        FILE_SAVED,
        FILE_SAVE_DONE,
        FILE_SAVE_TO_BYTES_DONE,
        ENTERED_ACTIVITY_WIZARD,
        APP_EXIT,
        LOCKED_INTERFACE_INVOKED,
        RESIZED;

    }

    public static class Resized
    extends AppWindowEvent {
        public int width;
        public int height;

        public Resized(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.RESIZED;
            this.width = (Integer)ltv.getEventParameters().get(0);
            this.height = (Integer)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\twidth = " + this.width + "\n\theight = " + this.height;
        }
    }

    public static class LockedInterfaceInvoked
    extends AppWindowEvent {
        public String lockMsg;
        public String lockID;
        public String branch1;
        public String branch2;

        public LockedInterfaceInvoked(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LOCKED_INTERFACE_INVOKED;
            this.lockMsg = (String)ltv.getEventParameters().get(0);
            this.lockID = (String)ltv.getEventParameters().get(1);
            this.branch1 = (String)ltv.getEventParameters().get(2);
            this.branch2 = (String)ltv.getEventParameters().get(3);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tlockMsg = " + this.lockMsg + "\n\tlockID = " + this.lockID + "\n\tbranch1 = " + this.branch1 + "\n\tbranch2 = " + this.branch2;
        }
    }

    public static class AppExit
    extends AppWindowEvent {
        public AppExit(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.APP_EXIT;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class EnteredActivityWizard
    extends AppWindowEvent {
        public Boolean convertedCurrentFile;

        public EnteredActivityWizard(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ENTERED_ACTIVITY_WIZARD;
            this.convertedCurrentFile = (Boolean)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tconvertedCurrentFile = " + this.convertedCurrentFile;
        }
    }

    public static class FileSaveToBytesDone
    extends AppWindowEvent {
        public List<Byte> data;

        public FileSaveToBytesDone(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_SAVE_TO_BYTES_DONE;
            this.data = (List)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdata = " + this.data;
        }
    }

    public static class FileSaveDone
    extends AppWindowEvent {
        public Boolean success;

        public FileSaveDone(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_SAVE_DONE;
            this.success = (Boolean)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tsuccess = " + this.success;
        }
    }

    public static class FileSaved
    extends AppWindowEvent {
        public FileSaved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_SAVED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class FileClosing
    extends AppWindowEvent {
        public FileClosing(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_CLOSING;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class ActivityFileOpening
    extends AppWindowEvent {
        public ActivityFileOpening(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ACTIVITY_FILE_OPENING;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class FileOpened
    extends AppWindowEvent {
        public FileOpened(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_OPENED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class FileNewed
    extends AppWindowEvent {
        public FileNewed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_NEWED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }
}

