/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.CableSignalingEvent;
import com.cisco.pt.ipc.events.CableSignalingEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.CableSignaling;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CableSignalingEventRegistry
extends IPCEventRegistry {
    protected Set<CableSignalingEventListener> globalListeners = new HashSet<CableSignalingEventListener>();
    protected Map<String, Set<CableSignalingEventListener>> specificObjectListeners = new HashMap<String, Set<CableSignalingEventListener>>();
    private static Log logger = LogFactory.getLog(CableSignalingEventRegistry.class);

    public CableSignalingEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "CableSignaling";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        CableSignalingEvent.UpdateTableEvent evt = null;
        if (!eventName.equalsIgnoreCase("updateTableEvent")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new CableSignalingEvent.UpdateTableEvent(event);
        for (CableSignalingEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<CableSignalingEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (CableSignalingEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(CableSignalingEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(CableSignalingEventListener listener, CableSignaling objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CableSignalingEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<CableSignalingEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(CableSignalingEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updateTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(CableSignalingEventListener listener, CableSignaling objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CableSignalingEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updateTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(CableSignalingEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(CableSignalingEventListener listener, CableSignaling objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(CableSignalingEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(CableSignalingEventListener listener, CableSignaling objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

