/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.CommandLogEvent;
import com.cisco.pt.ipc.events.CommandLogEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.system.CommandLog;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandLogEventRegistry
extends IPCEventRegistry {
    protected Set<CommandLogEventListener> globalListeners = new HashSet<CommandLogEventListener>();
    protected Map<String, Set<CommandLogEventListener>> specificObjectListeners = new HashMap<String, Set<CommandLogEventListener>>();
    private static Log logger = LogFactory.getLog(CommandLogEventRegistry.class);

    public CommandLogEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "CommandLog";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        CommandLogEvent.EntryAdded evt = null;
        if (!eventName.equalsIgnoreCase("entryAdded")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new CommandLogEvent.EntryAdded(event);
        for (CommandLogEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<CommandLogEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (CommandLogEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(CommandLogEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("entryAdded");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(CommandLogEventListener listener, CommandLog objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CommandLogEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<CommandLogEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "entryAdded");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(CommandLogEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("entryAdded");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(CommandLogEventListener listener, CommandLog objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CommandLogEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "entryAdded");
            specificListeners.remove(listener);
        }
    }

    public void addListener(CommandLogEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(CommandLogEventListener listener, CommandLog objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(CommandLogEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(CommandLogEventListener listener, CommandLog objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

