/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.ConsoleLineEvent;
import com.cisco.pt.ipc.events.ConsoleLineEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.ConsoleLine;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsoleLineEventRegistry
extends IPCEventRegistry {
    protected Set<ConsoleLineEventListener> globalListeners = new HashSet<ConsoleLineEventListener>();
    protected Map<String, Set<ConsoleLineEventListener>> specificObjectListeners = new HashMap<String, Set<ConsoleLineEventListener>>();
    private static Log logger = LogFactory.getLog(ConsoleLineEventRegistry.class);

    public ConsoleLineEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "ConsoleLine";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        ConsoleLineEvent.IdledOut evt = null;
        if (!eventName.equalsIgnoreCase("idledOut")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new ConsoleLineEvent.IdledOut(event);
        for (ConsoleLineEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<ConsoleLineEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (ConsoleLineEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(ConsoleLineEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("idledOut");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(ConsoleLineEventListener listener, ConsoleLine objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ConsoleLineEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<ConsoleLineEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "idledOut");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(ConsoleLineEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("idledOut");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(ConsoleLineEventListener listener, ConsoleLine objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ConsoleLineEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "idledOut");
            specificListeners.remove(listener);
        }
    }

    public void addListener(ConsoleLineEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(ConsoleLineEventListener listener, ConsoleLine objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(ConsoleLineEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(ConsoleLineEventListener listener, ConsoleLine objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

