/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class DHCPv6ClientProcessEvent
extends IPCEvent {
    public EventType type;

    public DHCPv6ClientProcessEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        DHCP_SUCCEED,
        DHCP_FAILED;

    }

    public static class DhcpFailed
    extends DHCPv6ClientProcessEvent {
        public String deviceName;
        public String portName;

        public DhcpFailed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DHCP_FAILED;
            this.deviceName = (String)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName;
        }
    }

    public static class DhcpSucceed
    extends DHCPv6ClientProcessEvent {
        public String deviceName;
        public String portName;
        public IPAddress newip;
        public int prefix;

        public DhcpSucceed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DHCP_SUCCEED;
            this.deviceName = (String)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
            this.newip = (IPAddress)ltv.getEventParameters().get(2);
            this.prefix = (Integer)ltv.getEventParameters().get(3);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName + "\n\tnewip = " + this.newip + "\n\tprefix = " + this.prefix;
        }
    }
}

