/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.DHCPv6ClientProcessEvent;
import com.cisco.pt.ipc.events.DHCPv6ClientProcessEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.DHCPv6ClientProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DHCPv6ClientProcessEventRegistry
extends IPCEventRegistry {
    protected Set<DHCPv6ClientProcessEventListener> globalListeners = new HashSet<DHCPv6ClientProcessEventListener>();
    protected Map<String, Set<DHCPv6ClientProcessEventListener>> specificObjectListeners = new HashMap<String, Set<DHCPv6ClientProcessEventListener>>();
    private static Log logger = LogFactory.getLog(DHCPv6ClientProcessEventRegistry.class);

    public DHCPv6ClientProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "DHCPv6ClientProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        DHCPv6ClientProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("dhcpSucceed")) {
            evt = new DHCPv6ClientProcessEvent.DhcpSucceed(event);
        } else if (eventName.equalsIgnoreCase("dhcpFailed")) {
            evt = new DHCPv6ClientProcessEvent.DhcpFailed(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (DHCPv6ClientProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<DHCPv6ClientProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (DHCPv6ClientProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(DHCPv6ClientProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("dhcpSucceed");
                this.register("dhcpFailed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(DHCPv6ClientProcessEventListener listener, DHCPv6ClientProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DHCPv6ClientProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<DHCPv6ClientProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "dhcpSucceed");
                this.register(uuid, "dhcpFailed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(DHCPv6ClientProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("dhcpSucceed");
                this.deregister("dhcpFailed");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(DHCPv6ClientProcessEventListener listener, DHCPv6ClientProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DHCPv6ClientProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "dhcpSucceed");
            this.deregister(uuid, "dhcpFailed");
            specificListeners.remove(listener);
        }
    }

    public void addListener(DHCPv6ClientProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(DHCPv6ClientProcessEventListener listener, DHCPv6ClientProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(DHCPv6ClientProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(DHCPv6ClientProcessEventListener listener, DHCPv6ClientProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

