/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.DialogManagerEvent;
import com.cisco.pt.ipc.events.DialogManagerEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.ui.DialogManager;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DialogManagerEventRegistry
extends IPCEventRegistry {
    protected Set<DialogManagerEventListener> globalListeners = new HashSet<DialogManagerEventListener>();
    protected Map<String, Set<DialogManagerEventListener>> specificObjectListeners = new HashMap<String, Set<DialogManagerEventListener>>();
    private static Log logger = LogFactory.getLog(DialogManagerEventRegistry.class);

    public DialogManagerEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "DialogManager";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        DialogManagerEvent evt = null;
        if (eventName.equalsIgnoreCase("dialogOpened")) {
            evt = new DialogManagerEvent.DialogOpened(event);
        } else if (eventName.equalsIgnoreCase("dialogClosed")) {
            evt = new DialogManagerEvent.DialogClosed(event);
        } else if (eventName.equalsIgnoreCase("dialogFocused")) {
            evt = new DialogManagerEvent.DialogFocused(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (DialogManagerEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<DialogManagerEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (DialogManagerEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(DialogManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("dialogOpened");
                this.register("dialogClosed");
                this.register("dialogFocused");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(DialogManagerEventListener listener, DialogManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DialogManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<DialogManagerEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "dialogOpened");
                this.register(uuid, "dialogClosed");
                this.register(uuid, "dialogFocused");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(DialogManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("dialogOpened");
                this.deregister("dialogClosed");
                this.deregister("dialogFocused");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(DialogManagerEventListener listener, DialogManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DialogManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "dialogOpened");
            this.deregister(uuid, "dialogClosed");
            this.deregister(uuid, "dialogFocused");
            specificListeners.remove(listener);
        }
    }

    public void addListener(DialogManagerEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(DialogManagerEventListener listener, DialogManager objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(DialogManagerEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(DialogManagerEventListener listener, DialogManager objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

