/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.DirectoryEvent;
import com.cisco.pt.ipc.events.DirectoryEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.Directory;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectoryEventRegistry
extends IPCEventRegistry {
    protected Set<DirectoryEventListener> globalListeners = new HashSet<DirectoryEventListener>();
    protected Map<String, Set<DirectoryEventListener>> specificObjectListeners = new HashMap<String, Set<DirectoryEventListener>>();
    private static Log logger = LogFactory.getLog(DirectoryEventRegistry.class);

    public DirectoryEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Directory";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        DirectoryEvent evt = null;
        if (eventName.equalsIgnoreCase("fileAdded")) {
            evt = new DirectoryEvent.FileAdded(event);
        } else if (eventName.equalsIgnoreCase("fileRemoved")) {
            evt = new DirectoryEvent.FileRemoved(event);
        } else if (eventName.equalsIgnoreCase("fileRenamed")) {
            evt = new DirectoryEvent.FileRenamed(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (DirectoryEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<DirectoryEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (DirectoryEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(DirectoryEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("fileAdded");
                this.register("fileRemoved");
                this.register("fileRenamed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(DirectoryEventListener listener, Directory objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DirectoryEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<DirectoryEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "fileAdded");
                this.register(uuid, "fileRemoved");
                this.register(uuid, "fileRenamed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(DirectoryEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("fileAdded");
                this.deregister("fileRemoved");
                this.deregister("fileRenamed");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(DirectoryEventListener listener, Directory objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DirectoryEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "fileAdded");
            this.deregister(uuid, "fileRemoved");
            this.deregister(uuid, "fileRenamed");
            specificListeners.remove(listener);
        }
    }

    public void addListener(DirectoryEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(DirectoryEventListener listener, Directory objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(DirectoryEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(DirectoryEventListener listener, Directory objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

