/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.HardwareQueueEvent;
import com.cisco.pt.ipc.events.HardwareQueueEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.HardwareQueue;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HardwareQueueEventRegistry
extends IPCEventRegistry {
    protected Set<HardwareQueueEventListener> globalListeners = new HashSet<HardwareQueueEventListener>();
    protected Map<String, Set<HardwareQueueEventListener>> specificObjectListeners = new HashMap<String, Set<HardwareQueueEventListener>>();
    private static Log logger = LogFactory.getLog(HardwareQueueEventRegistry.class);

    public HardwareQueueEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "HardwareQueue";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        HardwareQueueEvent.UpdateTableEvent evt = null;
        if (!eventName.equalsIgnoreCase("updateTableEvent")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new HardwareQueueEvent.UpdateTableEvent(event);
        for (HardwareQueueEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<HardwareQueueEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (HardwareQueueEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(HardwareQueueEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(HardwareQueueEventListener listener, HardwareQueue objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<HardwareQueueEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<HardwareQueueEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(HardwareQueueEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updateTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(HardwareQueueEventListener listener, HardwareQueue objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<HardwareQueueEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updateTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(HardwareQueueEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(HardwareQueueEventListener listener, HardwareQueue objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(HardwareQueueEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(HardwareQueueEventListener listener, HardwareQueue objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

