/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class IPCManagerEvent
extends IPCEvent {
    public EventType type;

    public IPCManagerEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        ON_SAVE,
        ON_OPEN,
        ON_OPENING;

    }

    public static class OnOpening
    extends IPCManagerEvent {
        public UUID openId;
        public String openData;

        public OnOpening(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ON_OPENING;
            this.openId = (UUID)ltv.getEventParameters().get(0);
            this.openData = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\topenId = " + this.openId + "\n\topenData = " + this.openData;
        }
    }

    public static class OnOpen
    extends IPCManagerEvent {
        public UUID openId;
        public String openData;

        public OnOpen(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ON_OPEN;
            this.openId = (UUID)ltv.getEventParameters().get(0);
            this.openData = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\topenId = " + this.openId + "\n\topenData = " + this.openData;
        }
    }

    public static class OnSave
    extends IPCManagerEvent {
        public UUID saveId;

        public OnSave(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ON_SAVE;
            this.saveId = (UUID)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tsaveId = " + this.saveId;
        }
    }
}

