/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.ConnectType;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class LogicalWorkspaceEvent
extends IPCEvent {
    public EventType type;

    public LogicalWorkspaceEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        DEVICE_ADDED,
        DEVICE_REMOVED,
        DEVICE_REMOVING,
        CANVAS_NOTE_TEXT_CHANGED,
        CANVAS_NOTE_REMOVED,
        CANVAS_NOTE_ADDED,
        REMOTE_NETWORK_ADDED,
        REMOTE_NETWORK_REMOVED,
        LINK_STARTED,
        LINK_CREATED,
        LINK_DELETED,
        SHOW_CLUSTER_CONTENTS,
        CLUSTER_ADDED,
        CLUSTER_REMOVED,
        CLUSTER_FOR_ITEM_CHANGED,
        ON_NO_AUTO_CONNECT_ERROR;

    }

    public static class OnNoAutoConnectError
    extends LogicalWorkspaceEvent {
        public String device1;
        public String device2;

        public OnNoAutoConnectError(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ON_NO_AUTO_CONNECT_ERROR;
            this.device1 = (String)ltv.getEventParameters().get(0);
            this.device2 = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdevice1 = " + this.device1 + "\n\tdevice2 = " + this.device2;
        }
    }

    public static class ClusterForItemChanged
    extends LogicalWorkspaceEvent {
        public UUID itemUuid;
        public String newClusterId;
        public String oldClusterId;

        public ClusterForItemChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CLUSTER_FOR_ITEM_CHANGED;
            this.itemUuid = (UUID)ltv.getEventParameters().get(0);
            this.newClusterId = (String)ltv.getEventParameters().get(1);
            this.oldClusterId = (String)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\titemUuid = " + this.itemUuid + "\n\tnewClusterId = " + this.newClusterId + "\n\toldClusterId = " + this.oldClusterId;
        }
    }

    public static class ClusterRemoved
    extends LogicalWorkspaceEvent {
        public String removedId;

        public ClusterRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CLUSTER_REMOVED;
            this.removedId = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tremovedId = " + this.removedId;
        }
    }

    public static class ClusterAdded
    extends LogicalWorkspaceEvent {
        public String addedId;

        public ClusterAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CLUSTER_ADDED;
            this.addedId = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\taddedId = " + this.addedId;
        }
    }

    public static class ShowClusterContents
    extends LogicalWorkspaceEvent {
        public String clusterId;

        public ShowClusterContents(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.SHOW_CLUSTER_CONTENTS;
            this.clusterId = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tclusterId = " + this.clusterId;
        }
    }

    public static class LinkDeleted
    extends LogicalWorkspaceEvent {
        public String deviceName1;
        public String portName1;
        public String deviceName2;
        public String portName2;
        public ConnectType connType;

        public LinkDeleted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINK_DELETED;
            this.deviceName1 = (String)ltv.getEventParameters().get(0);
            this.portName1 = (String)ltv.getEventParameters().get(1);
            this.deviceName2 = (String)ltv.getEventParameters().get(2);
            this.portName2 = (String)ltv.getEventParameters().get(3);
            this.connType = ConnectType.fromIntValue((Integer)ltv.getEventParameters().get(4));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdeviceName1 = " + this.deviceName1 + "\n\tportName1 = " + this.portName1 + "\n\tdeviceName2 = " + this.deviceName2 + "\n\tportName2 = " + this.portName2 + "\n\tconnType = " + (Object)((Object)this.connType);
        }
    }

    public static class LinkCreated
    extends LogicalWorkspaceEvent {
        public String deviceName1;
        public String portName1;
        public String deviceName2;
        public String portName2;
        public ConnectType connType;

        public LinkCreated(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINK_CREATED;
            this.deviceName1 = (String)ltv.getEventParameters().get(0);
            this.portName1 = (String)ltv.getEventParameters().get(1);
            this.deviceName2 = (String)ltv.getEventParameters().get(2);
            this.portName2 = (String)ltv.getEventParameters().get(3);
            this.connType = ConnectType.fromIntValue((Integer)ltv.getEventParameters().get(4));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdeviceName1 = " + this.deviceName1 + "\n\tportName1 = " + this.portName1 + "\n\tdeviceName2 = " + this.deviceName2 + "\n\tportName2 = " + this.portName2 + "\n\tconnType = " + (Object)((Object)this.connType);
        }
    }

    public static class LinkStarted
    extends LogicalWorkspaceEvent {
        public String deviceName1;
        public String portName1;
        public ConnectType connType;

        public LinkStarted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINK_STARTED;
            this.deviceName1 = (String)ltv.getEventParameters().get(0);
            this.portName1 = (String)ltv.getEventParameters().get(1);
            this.connType = ConnectType.fromIntValue((Integer)ltv.getEventParameters().get(2));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tdeviceName1 = " + this.deviceName1 + "\n\tportName1 = " + this.portName1 + "\n\tconnType = " + (Object)((Object)this.connType);
        }
    }

    public static class RemoteNetworkRemoved
    extends LogicalWorkspaceEvent {
        public String name;

        public RemoteNetworkRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.REMOTE_NETWORK_REMOVED;
            this.name = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tname = " + this.name;
        }
    }

    public static class RemoteNetworkAdded
    extends LogicalWorkspaceEvent {
        public String name;

        public RemoteNetworkAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.REMOTE_NETWORK_ADDED;
            this.name = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tname = " + this.name;
        }
    }

    public static class CanvasNoteAdded
    extends LogicalWorkspaceEvent {
        public UUID id;

        public CanvasNoteAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CANVAS_NOTE_ADDED;
            this.id = (UUID)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tid = " + this.id;
        }
    }

    public static class CanvasNoteRemoved
    extends LogicalWorkspaceEvent {
        public UUID id;

        public CanvasNoteRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CANVAS_NOTE_REMOVED;
            this.id = (UUID)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tid = " + this.id;
        }
    }

    public static class CanvasNoteTextChanged
    extends LogicalWorkspaceEvent {
        public UUID id;
        public String text;

        public CanvasNoteTextChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CANVAS_NOTE_TEXT_CHANGED;
            this.id = (UUID)ltv.getEventParameters().get(0);
            this.text = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tid = " + this.id + "\n\ttext = " + this.text;
        }
    }

    public static class DeviceRemoving
    extends LogicalWorkspaceEvent {
        public String name;
        public UUID deviceUuid;

        public DeviceRemoving(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_REMOVING;
            this.name = (String)ltv.getEventParameters().get(0);
            this.deviceUuid = (UUID)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tname = " + this.name + "\n\tdeviceUuid = " + this.deviceUuid;
        }
    }

    public static class DeviceRemoved
    extends LogicalWorkspaceEvent {
        public String name;
        public UUID deviceUuid;

        public DeviceRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_REMOVED;
            this.name = (String)ltv.getEventParameters().get(0);
            this.deviceUuid = (UUID)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tname = " + this.name + "\n\tdeviceUuid = " + this.deviceUuid;
        }
    }

    public static class DeviceAdded
    extends LogicalWorkspaceEvent {
        public String name;
        public String model;
        public UUID deviceUuid;

        public DeviceAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_ADDED;
            this.name = (String)ltv.getEventParameters().get(0);
            this.model = (String)ltv.getEventParameters().get(1);
            this.deviceUuid = (UUID)ltv.getEventParameters().get(2);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tname = " + this.name + "\n\tmodel = " + this.model + "\n\tdeviceUuid = " + this.deviceUuid;
        }
    }
}

