/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.LogicalWorkspaceEvent;
import com.cisco.pt.ipc.events.LogicalWorkspaceEventListener;
import com.cisco.pt.ipc.ui.LogicalWorkspace;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogicalWorkspaceEventRegistry
extends IPCEventRegistry {
    protected Set<LogicalWorkspaceEventListener> globalListeners = new HashSet<LogicalWorkspaceEventListener>();
    protected Map<String, Set<LogicalWorkspaceEventListener>> specificObjectListeners = new HashMap<String, Set<LogicalWorkspaceEventListener>>();
    private static Log logger = LogFactory.getLog(LogicalWorkspaceEventRegistry.class);

    public LogicalWorkspaceEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "LogicalWorkspace";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        LogicalWorkspaceEvent evt = null;
        if (eventName.equalsIgnoreCase("deviceAdded")) {
            evt = new LogicalWorkspaceEvent.DeviceAdded(event);
        } else if (eventName.equalsIgnoreCase("deviceRemoved")) {
            evt = new LogicalWorkspaceEvent.DeviceRemoved(event);
        } else if (eventName.equalsIgnoreCase("deviceRemoving")) {
            evt = new LogicalWorkspaceEvent.DeviceRemoving(event);
        } else if (eventName.equalsIgnoreCase("canvasNoteTextChanged")) {
            evt = new LogicalWorkspaceEvent.CanvasNoteTextChanged(event);
        } else if (eventName.equalsIgnoreCase("canvasNoteRemoved")) {
            evt = new LogicalWorkspaceEvent.CanvasNoteRemoved(event);
        } else if (eventName.equalsIgnoreCase("canvasNoteAdded")) {
            evt = new LogicalWorkspaceEvent.CanvasNoteAdded(event);
        } else if (eventName.equalsIgnoreCase("remoteNetworkAdded")) {
            evt = new LogicalWorkspaceEvent.RemoteNetworkAdded(event);
        } else if (eventName.equalsIgnoreCase("remoteNetworkRemoved")) {
            evt = new LogicalWorkspaceEvent.RemoteNetworkRemoved(event);
        } else if (eventName.equalsIgnoreCase("linkStarted")) {
            evt = new LogicalWorkspaceEvent.LinkStarted(event);
        } else if (eventName.equalsIgnoreCase("linkCreated")) {
            evt = new LogicalWorkspaceEvent.LinkCreated(event);
        } else if (eventName.equalsIgnoreCase("linkDeleted")) {
            evt = new LogicalWorkspaceEvent.LinkDeleted(event);
        } else if (eventName.equalsIgnoreCase("showClusterContents")) {
            evt = new LogicalWorkspaceEvent.ShowClusterContents(event);
        } else if (eventName.equalsIgnoreCase("clusterAdded")) {
            evt = new LogicalWorkspaceEvent.ClusterAdded(event);
        } else if (eventName.equalsIgnoreCase("clusterRemoved")) {
            evt = new LogicalWorkspaceEvent.ClusterRemoved(event);
        } else if (eventName.equalsIgnoreCase("clusterForItemChanged")) {
            evt = new LogicalWorkspaceEvent.ClusterForItemChanged(event);
        } else if (eventName.equalsIgnoreCase("onNoAutoConnectError")) {
            evt = new LogicalWorkspaceEvent.OnNoAutoConnectError(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (LogicalWorkspaceEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<LogicalWorkspaceEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (LogicalWorkspaceEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(LogicalWorkspaceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("deviceAdded");
                this.register("deviceRemoved");
                this.register("deviceRemoving");
                this.register("canvasNoteTextChanged");
                this.register("canvasNoteRemoved");
                this.register("canvasNoteAdded");
                this.register("remoteNetworkAdded");
                this.register("remoteNetworkRemoved");
                this.register("linkStarted");
                this.register("linkCreated");
                this.register("linkDeleted");
                this.register("showClusterContents");
                this.register("clusterAdded");
                this.register("clusterRemoved");
                this.register("clusterForItemChanged");
                this.register("onNoAutoConnectError");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<LogicalWorkspaceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<LogicalWorkspaceEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "deviceAdded");
                this.register(uuid, "deviceRemoved");
                this.register(uuid, "deviceRemoving");
                this.register(uuid, "canvasNoteTextChanged");
                this.register(uuid, "canvasNoteRemoved");
                this.register(uuid, "canvasNoteAdded");
                this.register(uuid, "remoteNetworkAdded");
                this.register(uuid, "remoteNetworkRemoved");
                this.register(uuid, "linkStarted");
                this.register(uuid, "linkCreated");
                this.register(uuid, "linkDeleted");
                this.register(uuid, "showClusterContents");
                this.register(uuid, "clusterAdded");
                this.register(uuid, "clusterRemoved");
                this.register(uuid, "clusterForItemChanged");
                this.register(uuid, "onNoAutoConnectError");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(LogicalWorkspaceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("deviceAdded");
                this.deregister("deviceRemoved");
                this.deregister("deviceRemoving");
                this.deregister("canvasNoteTextChanged");
                this.deregister("canvasNoteRemoved");
                this.deregister("canvasNoteAdded");
                this.deregister("remoteNetworkAdded");
                this.deregister("remoteNetworkRemoved");
                this.deregister("linkStarted");
                this.deregister("linkCreated");
                this.deregister("linkDeleted");
                this.deregister("showClusterContents");
                this.deregister("clusterAdded");
                this.deregister("clusterRemoved");
                this.deregister("clusterForItemChanged");
                this.deregister("onNoAutoConnectError");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<LogicalWorkspaceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "deviceAdded");
            this.deregister(uuid, "deviceRemoved");
            this.deregister(uuid, "deviceRemoving");
            this.deregister(uuid, "canvasNoteTextChanged");
            this.deregister(uuid, "canvasNoteRemoved");
            this.deregister(uuid, "canvasNoteAdded");
            this.deregister(uuid, "remoteNetworkAdded");
            this.deregister(uuid, "remoteNetworkRemoved");
            this.deregister(uuid, "linkStarted");
            this.deregister(uuid, "linkCreated");
            this.deregister(uuid, "linkDeleted");
            this.deregister(uuid, "showClusterContents");
            this.deregister(uuid, "clusterAdded");
            this.deregister(uuid, "clusterRemoved");
            this.deregister(uuid, "clusterForItemChanged");
            this.deregister(uuid, "onNoAutoConnectError");
            specificListeners.remove(listener);
        }
    }

    public void addListener(LogicalWorkspaceEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(LogicalWorkspaceEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(LogicalWorkspaceEventListener listener, LogicalWorkspace objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

