/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.MACSwitchEvent;
import com.cisco.pt.ipc.events.MACSwitchEventListener;
import com.cisco.pt.ipc.sim.MACSwitch;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MACSwitchEventRegistry
extends IPCEventRegistry {
    protected Set<MACSwitchEventListener> globalListeners = new HashSet<MACSwitchEventListener>();
    protected Map<String, Set<MACSwitchEventListener>> specificObjectListeners = new HashMap<String, Set<MACSwitchEventListener>>();
    private static Log logger = LogFactory.getLog(MACSwitchEventRegistry.class);

    public MACSwitchEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "MACSwitch";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        MACSwitchEvent evt = null;
        if (eventName.equalsIgnoreCase("updateTableEvent")) {
            evt = new MACSwitchEvent.UpdateTableEvent(event);
        } else if (eventName.equalsIgnoreCase("closeTableEvent")) {
            evt = new MACSwitchEvent.CloseTableEvent(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (MACSwitchEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<MACSwitchEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (MACSwitchEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(MACSwitchEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updateTableEvent");
                this.register("closeTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(MACSwitchEventListener listener, MACSwitch objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<MACSwitchEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<MACSwitchEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updateTableEvent");
                this.register(uuid, "closeTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(MACSwitchEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updateTableEvent");
                this.deregister("closeTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(MACSwitchEventListener listener, MACSwitch objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<MACSwitchEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updateTableEvent");
            this.deregister(uuid, "closeTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(MACSwitchEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(MACSwitchEventListener listener, MACSwitch objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(MACSwitchEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(MACSwitchEventListener listener, MACSwitch objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

