/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.OptionsEvent;
import com.cisco.pt.ipc.events.OptionsEventListener;
import com.cisco.pt.ipc.system.Options;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionsEventRegistry
extends IPCEventRegistry {
    protected Set<OptionsEventListener> globalListeners = new HashSet<OptionsEventListener>();
    protected Map<String, Set<OptionsEventListener>> specificObjectListeners = new HashMap<String, Set<OptionsEventListener>>();
    private static Log logger = LogFactory.getLog(OptionsEventRegistry.class);

    public OptionsEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Options";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        OptionsEvent.OptionsChanged evt = null;
        if (!eventName.equalsIgnoreCase("optionsChanged")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new OptionsEvent.OptionsChanged(event);
        for (OptionsEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<OptionsEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (OptionsEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(OptionsEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("optionsChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(OptionsEventListener listener, Options objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<OptionsEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<OptionsEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "optionsChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(OptionsEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("optionsChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(OptionsEventListener listener, Options objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<OptionsEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "optionsChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(OptionsEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(OptionsEventListener listener, Options objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(OptionsEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(OptionsEventListener listener, Options objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

