/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.PPPoeClientEvent;
import com.cisco.pt.ipc.events.PPPoeClientEventListener;
import com.cisco.pt.ipc.sim.PPPoeClient;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PPPoeClientEventRegistry
extends IPCEventRegistry {
    protected Set<PPPoeClientEventListener> globalListeners = new HashSet<PPPoeClientEventListener>();
    protected Map<String, Set<PPPoeClientEventListener>> specificObjectListeners = new HashMap<String, Set<PPPoeClientEventListener>>();
    private static Log logger = LogFactory.getLog(PPPoeClientEventRegistry.class);

    public PPPoeClientEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "PPPoeClient";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        PPPoeClientEvent.UpdatePppoeInfo evt = null;
        if (!eventName.equalsIgnoreCase("updatePppoeInfo")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new PPPoeClientEvent.UpdatePppoeInfo(event);
        for (PPPoeClientEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<PPPoeClientEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (PPPoeClientEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(PPPoeClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updatePppoeInfo");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(PPPoeClientEventListener listener, PPPoeClient objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PPPoeClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<PPPoeClientEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updatePppoeInfo");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(PPPoeClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updatePppoeInfo");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(PPPoeClientEventListener listener, PPPoeClient objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PPPoeClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updatePppoeInfo");
            specificListeners.remove(listener);
        }
    }

    public void addListener(PPPoeClientEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(PPPoeClientEventListener listener, PPPoeClient objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(PPPoeClientEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(PPPoeClientEventListener listener, PPPoeClient objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

