/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.PhoneSignalingEvent;
import com.cisco.pt.ipc.events.PhoneSignalingEventListener;
import com.cisco.pt.ipc.sim.PhoneSignaling;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhoneSignalingEventRegistry
extends IPCEventRegistry {
    protected Set<PhoneSignalingEventListener> globalListeners = new HashSet<PhoneSignalingEventListener>();
    protected Map<String, Set<PhoneSignalingEventListener>> specificObjectListeners = new HashMap<String, Set<PhoneSignalingEventListener>>();
    private static Log logger = LogFactory.getLog(PhoneSignalingEventRegistry.class);

    public PhoneSignalingEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "PhoneSignaling";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        PhoneSignalingEvent.UpdateTableEvent evt = null;
        if (!eventName.equalsIgnoreCase("updateTableEvent")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new PhoneSignalingEvent.UpdateTableEvent(event);
        for (PhoneSignalingEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<PhoneSignalingEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (PhoneSignalingEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(PhoneSignalingEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(PhoneSignalingEventListener listener, PhoneSignaling objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PhoneSignalingEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<PhoneSignalingEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(PhoneSignalingEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updateTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(PhoneSignalingEventListener listener, PhoneSignaling objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PhoneSignalingEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updateTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(PhoneSignalingEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(PhoneSignalingEventListener listener, PhoneSignaling objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(PhoneSignalingEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(PhoneSignalingEventListener listener, PhoneSignaling objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

