/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.Pop3ClientEvent;
import com.cisco.pt.ipc.events.Pop3ClientEventListener;
import com.cisco.pt.ipc.sim.Pop3Client;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pop3ClientEventRegistry
extends IPCEventRegistry {
    protected Set<Pop3ClientEventListener> globalListeners = new HashSet<Pop3ClientEventListener>();
    protected Map<String, Set<Pop3ClientEventListener>> specificObjectListeners = new HashMap<String, Set<Pop3ClientEventListener>>();
    private static Log logger = LogFactory.getLog(Pop3ClientEventRegistry.class);

    public Pop3ClientEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Pop3Client";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        Pop3ClientEvent evt = null;
        if (eventName.equalsIgnoreCase("mailReceived")) {
            evt = new Pop3ClientEvent.MailReceived(event);
        } else if (eventName.equalsIgnoreCase("errorReceivingMail")) {
            evt = new Pop3ClientEvent.ErrorReceivingMail(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (Pop3ClientEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<Pop3ClientEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (Pop3ClientEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(Pop3ClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("mailReceived");
                this.register("errorReceivingMail");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(Pop3ClientEventListener listener, Pop3Client objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<Pop3ClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<Pop3ClientEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "mailReceived");
                this.register(uuid, "errorReceivingMail");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(Pop3ClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("mailReceived");
                this.deregister("errorReceivingMail");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(Pop3ClientEventListener listener, Pop3Client objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<Pop3ClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "mailReceived");
            this.deregister(uuid, "errorReceivingMail");
            specificListeners.remove(listener);
        }
    }

    public void addListener(Pop3ClientEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(Pop3ClientEventListener listener, Pop3Client objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(Pop3ClientEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(Pop3ClientEventListener listener, Pop3Client objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

