/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.PortEvent;
import com.cisco.pt.ipc.events.PortEventListener;
import com.cisco.pt.ipc.sim.Port;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortEventRegistry
extends IPCEventRegistry {
    protected Set<PortEventListener> globalListeners = new HashSet<PortEventListener>();
    protected Map<String, Set<PortEventListener>> specificObjectListeners = new HashMap<String, Set<PortEventListener>>();
    private static Log logger = LogFactory.getLog(PortEventRegistry.class);

    public PortEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Port";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        PortEvent evt = null;
        if (eventName.equalsIgnoreCase("powerChanged")) {
            evt = new PortEvent.PowerChanged(event);
        } else if (eventName.equalsIgnoreCase("macChanged")) {
            evt = new PortEvent.MacChanged(event);
        } else if (eventName.equalsIgnoreCase("lightStatusChanged")) {
            evt = new PortEvent.LightStatusChanged(event);
        } else if (eventName.equalsIgnoreCase("lightBlinked")) {
            evt = new PortEvent.LightBlinked(event);
        } else if (eventName.equalsIgnoreCase("portStatusChanged")) {
            evt = new PortEvent.PortStatusChanged(event);
        } else if (eventName.equalsIgnoreCase("lineProtocolChanged")) {
            evt = new PortEvent.LineProtocolChanged(event);
        } else if (eventName.equalsIgnoreCase("packetReceived")) {
            evt = new PortEvent.PacketReceived(event);
        } else if (eventName.equalsIgnoreCase("packetSent")) {
            evt = new PortEvent.PacketSent(event);
        } else if (eventName.equalsIgnoreCase("packetReceivedWithDetails")) {
            evt = new PortEvent.PacketReceivedWithDetails(event);
        } else if (eventName.equalsIgnoreCase("packetSentWithDetails")) {
            evt = new PortEvent.PacketSentWithDetails(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (PortEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<PortEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (PortEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(PortEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("powerChanged");
                this.register("macChanged");
                this.register("lightStatusChanged");
                this.register("lightBlinked");
                this.register("portStatusChanged");
                this.register("lineProtocolChanged");
                this.register("packetReceived");
                this.register("packetSent");
                this.register("packetReceivedWithDetails");
                this.register("packetSentWithDetails");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(PortEventListener listener, Port objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PortEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<PortEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "powerChanged");
                this.register(uuid, "macChanged");
                this.register(uuid, "lightStatusChanged");
                this.register(uuid, "lightBlinked");
                this.register(uuid, "portStatusChanged");
                this.register(uuid, "lineProtocolChanged");
                this.register(uuid, "packetReceived");
                this.register(uuid, "packetSent");
                this.register(uuid, "packetReceivedWithDetails");
                this.register(uuid, "packetSentWithDetails");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(PortEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("powerChanged");
                this.deregister("macChanged");
                this.deregister("lightStatusChanged");
                this.deregister("lightBlinked");
                this.deregister("portStatusChanged");
                this.deregister("lineProtocolChanged");
                this.deregister("packetReceived");
                this.deregister("packetSent");
                this.deregister("packetReceivedWithDetails");
                this.deregister("packetSentWithDetails");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(PortEventListener listener, Port objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<PortEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "powerChanged");
            this.deregister(uuid, "macChanged");
            this.deregister(uuid, "lightStatusChanged");
            this.deregister(uuid, "lightBlinked");
            this.deregister(uuid, "portStatusChanged");
            this.deregister(uuid, "lineProtocolChanged");
            this.deregister(uuid, "packetReceived");
            this.deregister(uuid, "packetSent");
            this.deregister(uuid, "packetReceivedWithDetails");
            this.deregister(uuid, "packetSentWithDetails");
            specificListeners.remove(listener);
        }
    }

    public void addListener(PortEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(PortEventListener listener, Port objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(PortEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(PortEventListener listener, Port objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

