/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.RoutingProcessv6Event;
import com.cisco.pt.ipc.events.RoutingProcessv6EventListener;
import com.cisco.pt.ipc.sim.RoutingProcessv6;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoutingProcessv6EventRegistry
extends IPCEventRegistry {
    protected Set<RoutingProcessv6EventListener> globalListeners = new HashSet<RoutingProcessv6EventListener>();
    protected Map<String, Set<RoutingProcessv6EventListener>> specificObjectListeners = new HashMap<String, Set<RoutingProcessv6EventListener>>();
    private static Log logger = LogFactory.getLog(RoutingProcessv6EventRegistry.class);

    public RoutingProcessv6EventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "RoutingProcessv6";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        RoutingProcessv6Event evt = null;
        if (eventName.equalsIgnoreCase("routeAdded")) {
            evt = new RoutingProcessv6Event.RouteAdded(event);
        } else if (eventName.equalsIgnoreCase("routeRemoved")) {
            evt = new RoutingProcessv6Event.RouteRemoved(event);
        } else if (eventName.equalsIgnoreCase("networkAdded")) {
            evt = new RoutingProcessv6Event.NetworkAdded(event);
        } else if (eventName.equalsIgnoreCase("networkRemoved")) {
            evt = new RoutingProcessv6Event.NetworkRemoved(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (RoutingProcessv6EventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<RoutingProcessv6EventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (RoutingProcessv6EventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(RoutingProcessv6EventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("routeAdded");
                this.register("routeRemoved");
                this.register("networkAdded");
                this.register("networkRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(RoutingProcessv6EventListener listener, RoutingProcessv6 objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RoutingProcessv6EventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<RoutingProcessv6EventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "routeAdded");
                this.register(uuid, "routeRemoved");
                this.register(uuid, "networkAdded");
                this.register(uuid, "networkRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(RoutingProcessv6EventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("routeAdded");
                this.deregister("routeRemoved");
                this.deregister("networkAdded");
                this.deregister("networkRemoved");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(RoutingProcessv6EventListener listener, RoutingProcessv6 objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RoutingProcessv6EventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "routeAdded");
            this.deregister(uuid, "routeRemoved");
            this.deregister(uuid, "networkAdded");
            this.deregister(uuid, "networkRemoved");
            specificListeners.remove(listener);
        }
    }

    public void addListener(RoutingProcessv6EventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(RoutingProcessv6EventListener listener, RoutingProcessv6 objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(RoutingProcessv6EventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(RoutingProcessv6EventListener listener, RoutingProcessv6 objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

