/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.TrafficType;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class SimulationEvent
extends IPCEvent {
    public EventType type;

    public SimulationEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        FORWARD_STARTED,
        FORWARD_ENDED,
        NEW_FRAME_INSTANCE_ADDED,
        SIMULATION_RESET,
        SIMULATION_BUFFER_FULL,
        SIMULATION_MODE_CHANGED;

    }

    public static class SimulationModeChanged
    extends SimulationEvent {
        public SimulationModeChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.SIMULATION_MODE_CHANGED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class SimulationBufferFull
    extends SimulationEvent {
        public SimulationBufferFull(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.SIMULATION_BUFFER_FULL;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class SimulationReset
    extends SimulationEvent {
        public SimulationReset(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.SIMULATION_RESET;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class NewFrameInstanceAdded
    extends SimulationEvent {
        public TrafficType trafficType;
        public int index;

        public NewFrameInstanceAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NEW_FRAME_INSTANCE_ADDED;
            this.trafficType = TrafficType.fromIntValue((Integer)ltv.getEventParameters().get(0));
            this.index = (Integer)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\ttrafficType = " + (Object)((Object)this.trafficType) + "\n\tindex = " + this.index;
        }
    }

    public static class ForwardEnded
    extends SimulationEvent {
        public ForwardEnded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FORWARD_ENDED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class ForwardStarted
    extends SimulationEvent {
        public ForwardStarted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FORWARD_STARTED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }
}

