/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.SimulationTimerEvent;
import com.cisco.pt.ipc.events.SimulationTimerEventListener;
import com.cisco.pt.ipc.sim.SimulationTimer;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimulationTimerEventRegistry
extends IPCEventRegistry {
    protected Set<SimulationTimerEventListener> globalListeners = new HashSet<SimulationTimerEventListener>();
    protected Map<String, Set<SimulationTimerEventListener>> specificObjectListeners = new HashMap<String, Set<SimulationTimerEventListener>>();
    private static Log logger = LogFactory.getLog(SimulationTimerEventRegistry.class);

    public SimulationTimerEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "SimulationTimer";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        SimulationTimerEvent.Expired evt = null;
        if (!eventName.equalsIgnoreCase("expired")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new SimulationTimerEvent.Expired(event);
        for (SimulationTimerEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<SimulationTimerEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (SimulationTimerEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(SimulationTimerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("expired");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(SimulationTimerEventListener listener, SimulationTimer objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SimulationTimerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<SimulationTimerEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "expired");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(SimulationTimerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("expired");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(SimulationTimerEventListener listener, SimulationTimer objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SimulationTimerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "expired");
            specificListeners.remove(listener);
        }
    }

    public void addListener(SimulationTimerEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(SimulationTimerEventListener listener, SimulationTimer objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(SimulationTimerEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(SimulationTimerEventListener listener, SimulationTimer objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

