/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.SmtpClientEvent;
import com.cisco.pt.ipc.events.SmtpClientEventListener;
import com.cisco.pt.ipc.sim.SmtpClient;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmtpClientEventRegistry
extends IPCEventRegistry {
    protected Set<SmtpClientEventListener> globalListeners = new HashSet<SmtpClientEventListener>();
    protected Map<String, Set<SmtpClientEventListener>> specificObjectListeners = new HashMap<String, Set<SmtpClientEventListener>>();
    private static Log logger = LogFactory.getLog(SmtpClientEventRegistry.class);

    public SmtpClientEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "SmtpClient";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        SmtpClientEvent.MailSent evt = null;
        if (!eventName.equalsIgnoreCase("mailSent")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new SmtpClientEvent.MailSent(event);
        for (SmtpClientEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<SmtpClientEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (SmtpClientEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(SmtpClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("mailSent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(SmtpClientEventListener listener, SmtpClient objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SmtpClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<SmtpClientEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "mailSent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(SmtpClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("mailSent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(SmtpClientEventListener listener, SmtpClient objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<SmtpClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "mailSent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(SmtpClientEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(SmtpClientEventListener listener, SmtpClient objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(SmtpClientEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(SmtpClientEventListener listener, SmtpClient objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

