/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.VLANEvent;
import com.cisco.pt.ipc.events.VLANEventListener;
import com.cisco.pt.ipc.sim.VLAN;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VLANEventRegistry
extends IPCEventRegistry {
    protected Set<VLANEventListener> globalListeners = new HashSet<VLANEventListener>();
    protected Map<String, Set<VLANEventListener>> specificObjectListeners = new HashMap<String, Set<VLANEventListener>>();
    private static Log logger = LogFactory.getLog(VLANEventRegistry.class);

    public VLANEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Vlan";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        VLANEvent evt = null;
        if (eventName.equalsIgnoreCase("macEntryAdded")) {
            evt = new VLANEvent.MacEntryAdded(event);
        } else if (eventName.equalsIgnoreCase("macEntryRemoved")) {
            evt = new VLANEvent.MacEntryRemoved(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (VLANEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<VLANEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (VLANEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(VLANEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("macEntryAdded");
                this.register("macEntryRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(VLANEventListener listener, VLAN objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<VLANEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<VLANEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "macEntryAdded");
                this.register(uuid, "macEntryRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(VLANEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("macEntryAdded");
                this.deregister("macEntryRemoved");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(VLANEventListener listener, VLAN objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<VLANEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "macEntryAdded");
            this.deregister(uuid, "macEntryRemoved");
            specificListeners.remove(listener);
        }
    }

    public void addListener(VLANEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(VLANEventListener listener, VLAN objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(VLANEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(VLANEventListener listener, VLAN objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

