/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.VLANManagerEvent;
import com.cisco.pt.ipc.events.VLANManagerEventListener;
import com.cisco.pt.ipc.sim.VLANManager;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VLANManagerEventRegistry
extends IPCEventRegistry {
    protected Set<VLANManagerEventListener> globalListeners = new HashSet<VLANManagerEventListener>();
    protected Map<String, Set<VLANManagerEventListener>> specificObjectListeners = new HashMap<String, Set<VLANManagerEventListener>>();
    private static Log logger = LogFactory.getLog(VLANManagerEventRegistry.class);

    public VLANManagerEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "VLANManager";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        VLANManagerEvent.UpdateTableEvent evt = null;
        if (!eventName.equalsIgnoreCase("updateTableEvent")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new VLANManagerEvent.UpdateTableEvent(event);
        for (VLANManagerEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<VLANManagerEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (VLANManagerEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(VLANManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(VLANManagerEventListener listener, VLANManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<VLANManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<VLANManagerEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "updateTableEvent");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(VLANManagerEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("updateTableEvent");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(VLANManagerEventListener listener, VLANManager objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<VLANManagerEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "updateTableEvent");
            specificListeners.remove(listener);
        }
    }

    public void addListener(VLANManagerEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(VLANManagerEventListener listener, VLANManager objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(VLANManagerEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(VLANManagerEventListener listener, VLANManager objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

