/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;
import com.cisco.pt.ipc.ui.SmFileSystemResourceRequest;

public abstract class WebViewEvent
extends IPCEvent {
    public EventType type;

    public WebViewEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        CLOSE_REQUESTED,
        CLOSED,
        ON_FOCUS,
        OFF_FOCUS,
        JAVASCRIPT_DONE,
        FILE_SYSTEM_RESOURCE_REQUESTED;

    }

    public static class FileSystemResourceRequested
    extends WebViewEvent {
        public SmFileSystemResourceRequest request;

        public FileSystemResourceRequested(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_SYSTEM_RESOURCE_REQUESTED;
            this.request = (SmFileSystemResourceRequest)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\trequest = " + this.request;
        }
    }

    public static class JavascriptDone
    extends WebViewEvent {
        public String id;
        public String result;

        public JavascriptDone(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.JAVASCRIPT_DONE;
            this.id = (String)ltv.getEventParameters().get(0);
            this.result = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tid = " + this.id + "\n\tresult = " + this.result;
        }
    }

    public static class OffFocus
    extends WebViewEvent {
        public OffFocus(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.OFF_FOCUS;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class OnFocus
    extends WebViewEvent {
        public OnFocus(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.ON_FOCUS;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class Closed
    extends WebViewEvent {
        public UUID id;

        public Closed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CLOSED;
            this.id = (UUID)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tid = " + this.id;
        }
    }

    public static class CloseRequested
    extends WebViewEvent {
        public UUID id;

        public CloseRequested(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CLOSE_REQUESTED;
            this.id = (UUID)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tid = " + this.id;
        }
    }
}

