/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.impl;

import com.cisco.pt.LTV;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCErrorLTV;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.IPCObject;
import com.cisco.pt.ipc.enums.CommandStatus;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IPCObjectImpl
implements IPCObject {
    protected IPCFactory ipcFactory;
    protected PacketTracerSession packetTracerSession;
    protected IPCMessageLTV accessMessage;
    private static Log logger = LogFactory.getLog(IPCObjectImpl.class);

    public IPCObjectImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        this.ipcFactory = ipcFactory;
        this.packetTracerSession = packetTracerSession;
        this.accessMessage = accessMessage;
    }

    @Override
    public IPCFactory getFactory() {
        return this.ipcFactory;
    }

    @Override
    public PacketTracerSession getPacketTracerSession() {
        return this.packetTracerSession;
    }

    @Override
    public IPCMessageLTV getAccessMessage() {
        return this.accessMessage;
    }

    @Override
    public String getClassName() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getClassName");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public UUID getObjectUUID() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getObjectUuid");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (UUID)returnMessage.getObjectValue();
    }

    protected void sendMessage(IPCMessageLTV message) {
        try {
            this.getPacketTracerSession().write(message);
        }
        catch (IOException e) {
            throw new IPCError("Error during send of " + message, e);
        }
    }

    protected IPCResponseLTV sendMessageWithReturn(IPCMessageLTV message) {
        try {
            LTV rawResponse = this.getPacketTracerSession().writeRead(message);
            if (rawResponse instanceof IPCResponseLTV) {
                logger.info((Object)("Return value = " + rawResponse));
                return (IPCResponseLTV)rawResponse;
            }
            if (rawResponse instanceof IPCErrorLTV) {
                IPCErrorLTV errorMessage = (IPCErrorLTV)rawResponse;
                if (errorMessage.getErrorMessage().startsWith("IPC Cache entry")) {
                    return null;
                }
                throw new IPCError("IPC Interface Error:  [" + errorMessage.getMessageId() + "] <" + errorMessage.getErrorMessage() + ">");
            }
            throw new IPCError("IPC Interface Error:  Unrecognized response message type: " + rawResponse);
        }
        catch (IOException e) {
            throw new IPCError("Error during send of " + message, e);
        }
    }

    protected Pair<CommandStatus, String> translateToCommandStatusStringPair(Pair<Integer, String> rawPair) {
        return new Pair<CommandStatus, String>(CommandStatus.fromIntValue(rawPair.getFirst()), rawPair.getSecond());
    }
}

