/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.MACAddress;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.BluetoothDevice;
import com.cisco.pt.ipc.sim.BluetoothManager;
import com.cisco.pt.ipc.sim.CustomBluetoothProcess;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;

public class BluetoothManagerImpl
extends ProcessImpl
implements BluetoothManager {
    public BluetoothManagerImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public void setDiscoverable(boolean bDiscoverable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDiscoverable");
        newCall.addBoolParameter(bDiscoverable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isDiscoverable() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isDiscoverable");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: BluetoothManagerImpl.isDiscoverable");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void discover() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("discover");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void pair(MACAddress macAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("pair");
        newCall.addMACAddressParameter(macAddress);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void acceptPairRequest(MACAddress macAddress, String deviceName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("acceptPairRequest");
        newCall.addMACAddressParameter(macAddress);
        newCall.addQStringParameter(deviceName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void unpair(MACAddress macAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("unpair");
        newCall.addMACAddressParameter(macAddress);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean processPairRequest(MACAddress macAddress, String deviceName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("processPairRequest");
        newCall.addMACAddressParameter(macAddress);
        newCall.addQStringParameter(deviceName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: BluetoothManagerImpl.processPairRequest");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getDeviceCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDeviceCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: BluetoothManagerImpl.getDeviceCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public BluetoothDevice getDeviceAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDeviceAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (BluetoothDevice)returnMessage.getObjectValue();
    }

    @Override
    public BluetoothDevice getDevice(MACAddress macAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDevice");
        newCall.addMACAddressParameter(macAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (BluetoothDevice)returnMessage.getObjectValue();
    }

    @Override
    public BluetoothDevice getDeviceByName(String deviceName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDeviceByName");
        newCall.addQStringParameter(deviceName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (BluetoothDevice)returnMessage.getObjectValue();
    }

    @Override
    public void enableBroadcast(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("enableBroadcast");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isBroadcastEnabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isBroadcastEnabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: BluetoothManagerImpl.isBroadcastEnabled");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setBeaconBroadcasting(boolean bBroadcast) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setBeaconBroadcasting");
        newCall.addBoolParameter(bBroadcast);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isBeaconBroadcasting() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isBeaconBroadcasting");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: BluetoothManagerImpl.isBeaconBroadcasting");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setBeaconFrequency(int secs) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setBeaconFrequency");
        newCall.addIntParameter(secs);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getBeaconFrequency() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getBeaconFrequency");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: BluetoothManagerImpl.getBeaconFrequency");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public void setBeaconUuid(UUID beaconUuid) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setBeaconUuid");
        newCall.addUUIDParameter(beaconUuid);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public UUID getBeaconUuid() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getBeaconUuid");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (UUID)returnMessage.getObjectValue();
    }

    @Override
    public void setBeaconData(String data) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setBeaconData");
        newCall.addQStringParameter(data);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getBeaconData() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getBeaconData");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public boolean broadcastBeacon(UUID beaconUuid, String data) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("broadcastBeacon");
        newCall.addUUIDParameter(beaconUuid);
        newCall.addQStringParameter(data);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: BluetoothManagerImpl.broadcastBeacon");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public CustomBluetoothProcess createCustomProcess() {
        return this.getFactory().createCustomProcess(this);
    }
}

