/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.DHCPPool;
import com.cisco.pt.ipc.sim.DHCPServerProcess;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;

public class DHCPServerProcessImpl
extends ProcessImpl
implements DHCPServerProcess {
    public DHCPServerProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public void addExcludedAddress(IPAddress startIp, IPAddress endIp) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addExcludedAddress");
        newCall.addIPAddressParameter(startIp);
        newCall.addIPAddressParameter(endIp);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeExcludedAddress(IPAddress startIp, IPAddress endIp) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeExcludedAddress");
        newCall.addIPAddressParameter(startIp);
        newCall.addIPAddressParameter(endIp);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void updateNetworkReservation(IPAddress newNet) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("updateNetworkReservation");
        newCall.addIPAddressParameter(newNet);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getExcludedAddressCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getExcludedAddressCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DHCPServerProcessImpl.getExcludedAddressCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public Pair<IPAddress, IPAddress> getExcludedAddressAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getExcludedAddressAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        Pair rawPair = (Pair)returnMessage.getObjectValue();
        Pair<IPAddress, IPAddress> answer = new Pair<IPAddress, IPAddress>((IPAddress)rawPair.getFirst(), (IPAddress)rawPair.getSecond());
        return answer;
    }

    @Override
    public void addPool(String poolName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addPool");
        newCall.addStringParameter(poolName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void addNewPool(String poolName, String gateway, String dnsServer, String startIp, String subnetMask, int maxUsers, String tftpServerIp, String wlcIp) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addNewPool");
        newCall.addStringParameter(poolName);
        newCall.addStringParameter(gateway);
        newCall.addStringParameter(dnsServer);
        newCall.addStringParameter(startIp);
        newCall.addStringParameter(subnetMask);
        newCall.addIntParameter(maxUsers);
        newCall.addStringParameter(tftpServerIp);
        newCall.addStringParameter(wlcIp);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public DHCPPool getPool(String poolName) {
        return this.getFactory().getPool(this, poolName);
    }

    @Override
    public void removePool(String poolName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removePool");
        newCall.addStringParameter(poolName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getPoolCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPoolCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DHCPServerProcessImpl.getPoolCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public DHCPPool getPoolAt(int index) {
        return this.getFactory().getPoolAt(this, index);
    }

    @Override
    public boolean isEnable() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEnable");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DHCPServerProcessImpl.isEnable");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setEnable(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setEnable");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }
}

