/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.DeviceType;
import com.cisco.pt.ipc.enums.ModuleType;
import com.cisco.pt.ipc.impl.IPCObjectImpl;
import com.cisco.pt.ipc.sim.Device;
import com.cisco.pt.ipc.sim.DeviceDescriptor;
import com.cisco.pt.ipc.sim.Module;
import com.cisco.pt.ipc.sim.Port;
import com.cisco.pt.ipc.sim.Process;
import com.cisco.pt.ipc.sim.TerminalLine;
import com.cisco.pt.ipc.sim.UsbPort;
import com.cisco.pt.ipc.sim.UserDesktopAppConfig;
import com.cisco.pt.ipc.ui.PhysicalObject;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.ArrayList;
import java.util.List;

public class DeviceImpl
extends IPCObjectImpl
implements Device {
    public DeviceImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public void setName(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setName");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getName() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getName");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setPower(boolean bOn) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setPower");
        newCall.addBoolParameter(bOn);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void addSound(String soundPath, String soundID) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addSound");
        newCall.addQStringParameter(soundPath);
        newCall.addQStringParameter(soundID);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void playSound(String soundID, int numLoop) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("playSound");
        newCall.addQStringParameter(soundID);
        newCall.addIntParameter(numLoop);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void stopSound(String soundID) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("stopSound");
        newCall.addQStringParameter(soundID);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void stopSounds() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("stopSounds");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void destroySounds() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("destroySounds");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean getPower() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPower");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getPower");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public double getXCoordinate() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getXCoordinate");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getXCoordinate");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public double getYCoordinate() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getYCoordinate");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getYCoordinate");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public double getCenterXCoordinate() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCenterXCoordinate");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getCenterXCoordinate");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public double getCenterYCoordinate() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCenterYCoordinate");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getCenterYCoordinate");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public double getAreaTopY() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaTopY");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getAreaTopY");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public double getAreaLeftX() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaLeftX");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getAreaLeftX");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public boolean moveToLocationCentered(int x, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveToLocationCentered");
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.moveToLocationCentered");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean moveToLocation(int x, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveToLocation");
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.moveToLocation");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getXPhysicalWS() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getXPhysicalWS");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getXPhysicalWS");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getYPhysicalWS() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getYPhysicalWS");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getYPhysicalWS");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public double getGlobalXPhysicalWS() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getGlobalXPhysicalWS");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getGlobalXPhysicalWS");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public double getGlobalYPhysicalWS() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getGlobalYPhysicalWS");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getGlobalYPhysicalWS");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public boolean moveToLocInPhysicalWS(int x, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveToLocInPhysicalWS");
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.moveToLocInPhysicalWS");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean moveByInPhysicalWS(int x, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveByInPhysicalWS");
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.moveByInPhysicalWS");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public DeviceType getType() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getType");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getType");
        }
        return DeviceType.fromIntValue(returnMessage.getIntValue());
    }

    @Override
    public String getModel() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getModel");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public DeviceDescriptor getDescriptor() {
        return this.getFactory().getDescriptor(this);
    }

    @Override
    public String getSerialNumber() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSerialNumber");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public Port getPort(String portName) {
        return this.getFactory().getPort(this, portName);
    }

    @Override
    public int getPortCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPortCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getPortCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public Port getPortAt(int index) {
        return this.getFactory().getPortAt(this, index);
    }

    @Override
    public Process getProcess(String process) {
        return this.getFactory().getProcess(this, process);
    }

    @Override
    public int getUsbPortCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUsbPortCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getUsbPortCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public UsbPort getUsbPortAt(int index) {
        return this.getFactory().getUsbPortAt(this, index);
    }

    @Override
    public Module getRootModule() {
        return this.getFactory().getRootModule(this);
    }

    @Override
    public boolean addModule(String slot, ModuleType type, String model) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addModule");
        newCall.addStringParameter(slot);
        newCall.addIntParameter(type.getIntValue());
        newCall.addStringParameter(model);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.addModule");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeModule(String slot) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeModule");
        newCall.addStringParameter(slot);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.removeModule");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public TerminalLine getCommandLine() {
        return this.getFactory().getCommandLine(this);
    }

    @Override
    public void addCustomVar(String name, String var) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addCustomVar");
        newCall.addQStringParameter(name);
        newCall.addQStringParameter(var);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean removeCustomVar(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeCustomVar");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.removeCustomVar");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean hasCustomVar(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("hasCustomVar");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.hasCustomVar");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public String getCustomVarStr(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarStr");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public int getCustomVarsCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarsCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getCustomVarsCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public String getCustomVarNameAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarNameAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String getCustomVarValueStrAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarValueStrAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setCustomInterface(String inf) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setCustomInterface");
        newCall.addQStringParameter(inf);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getCustomInterface() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomInterface");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String serializeToXml() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("serializeToXml");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String activityTreeToXml() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("activityTreeToXml");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public PhysicalObject getPhysicalObject() {
        return this.getFactory().getPhysicalObject(this);
    }

    @Override
    public String getCustomLogicalImage() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomLogicalImage");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setCustomLogicalImage(String strPath) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setCustomLogicalImage");
        newCall.addQStringParameter(strPath);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getCustomPhysicalImage() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomPhysicalImage");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setCustomPhysicalImage(String strPath) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setCustomPhysicalImage");
        newCall.addQStringParameter(strPath);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public List<String> getSupportedModule() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSupportedModule");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public void setTime(int uiHour, int uiMin, int uiSec, int uiDay, int uiMonth, int uiYear) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setTime");
        newCall.addIntParameter(uiHour);
        newCall.addIntParameter(uiMin);
        newCall.addIntParameter(uiSec);
        newCall.addIntParameter(uiDay);
        newCall.addIntParameter(uiMonth);
        newCall.addIntParameter(uiYear);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public long getUpTime() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUpTime");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getUpTime");
        }
        return returnMessage.getLongValue();
    }

    @Override
    public List<String> getPorts() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPorts");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public double getDeviceExternalAttributeValue(String attribute) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDeviceExternalAttributeValue");
        newCall.addStringParameter(attribute);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getDeviceExternalAttributeValue");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public void setDeviceExternalAttributes(String attributeValues) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDeviceExternalAttributes");
        newCall.addQStringParameter(attributeValues);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void addDeviceExternalAttributes(String attributeValues) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addDeviceExternalAttributes");
        newCall.addQStringParameter(attributeValues);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void subtractDeviceExternalAttributes(String attributeValues) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("subtractDeviceExternalAttributes");
        newCall.addQStringParameter(attributeValues);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getDeviceExternalAttributes() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDeviceExternalAttributes");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void clearDeviceExternalAttributes() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("clearDeviceExternalAttributes");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isOutdated() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isOutdated");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.isOutdated");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean restoreToDefault(boolean bMakeCopy, boolean bMarkCustomizedUpdated) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("restoreToDefault");
        newCall.addBoolParameter(bMakeCopy);
        newCall.addBoolParameter(bMarkCustomizedUpdated);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.restoreToDefault");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void updateTemplateCreationTime() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("updateTemplateCreationTime");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean runProject(String projectName, String extraCode) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("runProject");
        newCall.addStringParameter(projectName);
        newCall.addStringParameter(extraCode);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.runProject");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean stopProject(String projectName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("stopProject");
        newCall.addStringParameter(projectName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.stopProject");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean isProjectRunning(String projectName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isProjectRunning");
        newCall.addStringParameter(projectName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.isProjectRunning");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean runCodeInProject(String projectName, String code) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("runCodeInProject");
        newCall.addStringParameter(projectName);
        newCall.addStringParameter(code);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.runCodeInProject");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void addProgrammingSerialOutputs(String output) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addProgrammingSerialOutputs");
        newCall.addStringParameter(output);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getProgrammingSerialOutputs() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getProgrammingSerialOutputs");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void clearProgrammingSerialOutputs() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("clearProgrammingSerialOutputs");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public UserDesktopAppConfig addUserDesktopApp(String dirName) {
        return this.getFactory().addUserDesktopApp(this, dirName);
    }

    @Override
    public UserDesktopAppConfig addUserDesktopAppFromGlobal(String id) {
        return this.getFactory().addUserDesktopAppFromGlobal(this, id);
    }

    @Override
    public int getUserDesktopAppCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUserDesktopAppCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getUserDesktopAppCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public UserDesktopAppConfig getUserDesktopAppAt(int index) {
        return this.getFactory().getUserDesktopAppAt(this, index);
    }

    @Override
    public UserDesktopAppConfig getUserDesktopAppByDir(String dirName) {
        return this.getFactory().getUserDesktopAppByDir(this, dirName);
    }

    @Override
    public UserDesktopAppConfig getUserDesktopAppById(String id) {
        return this.getFactory().getUserDesktopAppById(this, id);
    }

    @Override
    public void removeUserDesktopApp(String dirName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeUserDesktopApp");
        newCall.addStringParameter(dirName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void relinkUserDesktopApp(String oldDirName, String newDirName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("relinkUserDesktopApp");
        newCall.addStringParameter(oldDirName);
        newCall.addStringParameter(newDirName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isDesktopAvailable() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isDesktopAvailable");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.isDesktopAvailable");
        }
        return returnMessage.getBoolValue();
    }
}

