/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.RouterPort;
import com.cisco.pt.ipc.sim.VLAN;
import com.cisco.pt.ipc.sim.VLANManager;
import com.cisco.pt.ipc.sim.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;

public class VLANManagerImpl
extends ProcessImpl
implements VLANManager {
    public VLANManagerImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public VLAN getVlan(int vlanID) {
        return this.getFactory().getVlan(this, vlanID);
    }

    @Override
    public VLAN getVlanAt(int index) {
        return this.getFactory().getVlanAt(this, index);
    }

    @Override
    public boolean addVlan(int vlandID, String vlanName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addVlan");
        newCall.addIntParameter(vlandID);
        newCall.addStringParameter(vlanName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.addVlan");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeVlan(int vlandID) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeVlan");
        newCall.addIntParameter(vlandID);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.removeVlan");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getVlanCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getVlanCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.getVlanCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getMaxVlans() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getMaxVlans");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.getMaxVlans");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public VLAN getVlanByName(String name) {
        return this.getFactory().getVlanByName(this, name);
    }

    @Override
    public boolean changeVlanName(int vlanID, String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("changeVlanName");
        newCall.addIntParameter(vlanID);
        newCall.addStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.changeVlanName");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean addVlanInt(int vlanID) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addVlanInt");
        newCall.addIntParameter(vlanID);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.addVlanInt");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeVlanInt(int vlanID) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeVlanInt");
        newCall.addIntParameter(vlanID);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.removeVlanInt");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public RouterPort getVlanInt(int vlanID) {
        return this.getFactory().getVlanInt(this, vlanID);
    }

    @Override
    public RouterPort getVlanIntAt(int index) {
        return this.getFactory().getVlanIntAt(this, index);
    }

    @Override
    public int getVlanIntCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getVlanIntCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: VLANManagerImpl.getVlanIntCount");
        }
        return returnMessage.getIntValue();
    }
}

