/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.MACAddress;
import com.cisco.pt.UUID;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.BluetoothFrame;
import com.cisco.pt.ipc.sim.pdu.impl.HeaderImpl;
import com.cisco.pt.util.Pair;
import java.util.Collections;
import java.util.List;

public class BluetoothFrameImpl
extends HeaderImpl
implements BluetoothFrame {
    protected MACAddress srcMac;
    protected MACAddress dstMac;
    protected UUID srcService;
    protected UUID dstService;

    public BluetoothFrameImpl() {
        this.fieldNames.add("BluetoothFrameImpl_srcMac");
        this.fieldNames.add("BluetoothFrameImpl_dstMac");
        this.fieldNames.add("BluetoothFrameImpl_srcService");
        this.fieldNames.add("BluetoothFrameImpl_dstService");
        this.signalType = "BluetoothFrame";
    }

    @Override
    public MACAddress getSrcMac() {
        return this.srcMac;
    }

    @Override
    public void setSrcMac(MACAddress srcMac) {
        this.srcMac = srcMac;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("BluetoothFrameImpl_srcMac")) continue;
            this.fieldTable.set(i, new Pair<String, MACAddress>("BluetoothFrameImpl_srcMac", srcMac));
            return;
        }
    }

    @Override
    public MACAddress getDstMac() {
        return this.dstMac;
    }

    @Override
    public void setDstMac(MACAddress dstMac) {
        this.dstMac = dstMac;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("BluetoothFrameImpl_dstMac")) continue;
            this.fieldTable.set(i, new Pair<String, MACAddress>("BluetoothFrameImpl_dstMac", dstMac));
            return;
        }
    }

    @Override
    public UUID getSrcService() {
        return this.srcService;
    }

    @Override
    public void setSrcService(UUID srcService) {
        this.srcService = srcService;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("BluetoothFrameImpl_srcService")) continue;
            this.fieldTable.set(i, new Pair<String, UUID>("BluetoothFrameImpl_srcService", srcService));
            return;
        }
    }

    @Override
    public UUID getDstService() {
        return this.dstService;
    }

    @Override
    public void setDstService(UUID dstService) {
        this.dstService = dstService;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("BluetoothFrameImpl_dstService")) continue;
            this.fieldTable.set(i, new Pair<String, UUID>("BluetoothFrameImpl_dstService", dstService));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("BluetoothFrameImpl_srcMac")) {
            return PtmpTypeValue.MAC_ADDRESS;
        }
        if (fieldName.equals("BluetoothFrameImpl_dstMac")) {
            return PtmpTypeValue.MAC_ADDRESS;
        }
        if (fieldName.equals("BluetoothFrameImpl_srcService")) {
            return PtmpTypeValue.UUID;
        }
        if (fieldName.equals("BluetoothFrameImpl_dstService")) {
            return PtmpTypeValue.UUID;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, MACAddress>("BluetoothFrameImpl_srcMac", this.srcMac));
        this.fieldTable.add(new Pair<String, MACAddress>("BluetoothFrameImpl_dstMac", this.dstMac));
        this.fieldTable.add(new Pair<String, UUID>("BluetoothFrameImpl_srcService", this.srcService));
        this.fieldTable.add(new Pair<String, UUID>("BluetoothFrameImpl_dstService", this.dstService));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.srcMac = this.readMACAddress(buffer);
        this.dstMac = this.readMACAddress(buffer);
        this.srcService = this.readUUID(buffer);
        this.dstService = this.readUUID(buffer);
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.srcMac = this.pduReadMACAddress(buffer);
        this.dstMac = this.pduReadMACAddress(buffer);
        this.srcService = this.pduReadUUID(buffer);
        this.dstService = this.pduReadUUID(buffer);
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putMACAddress(this.srcMac);
        buffer.putMACAddress(this.dstMac);
        buffer.putUUID(this.srcService);
        buffer.putUUID(this.dstService);
    }
}

