/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.IPV6Header;
import com.cisco.pt.ipc.sim.pdu.IPV6NextHeader;
import com.cisco.pt.ipc.sim.pdu.impl.HeaderImpl;
import com.cisco.pt.util.Pair;
import java.util.Collections;
import java.util.List;

public class IPV6HeaderImpl
extends HeaderImpl
implements IPV6Header {
    protected IPV6NextHeader nextHeader;
    protected Byte version;
    protected Byte headerLength;
    protected Byte typeOfService;
    protected Short totalLength;
    protected Short identification;
    protected Byte flags;
    protected Short fragmentOffset;
    protected Short protocol;
    protected Short headerChecksum;
    protected int options;
    protected int padding;
    protected IPV6Address sourceAddress;
    protected IPV6Address destinationAddress;

    public IPV6HeaderImpl() {
        this.fieldNames.add("IPV6HeaderImpl_nextHeader");
        this.fieldNames.add("IPV6HeaderImpl_version");
        this.fieldNames.add("IPV6HeaderImpl_headerLength");
        this.fieldNames.add("IPV6HeaderImpl_typeOfService");
        this.fieldNames.add("IPV6HeaderImpl_totalLength");
        this.fieldNames.add("IPV6HeaderImpl_identification");
        this.fieldNames.add("IPV6HeaderImpl_flags");
        this.fieldNames.add("IPV6HeaderImpl_fragmentOffset");
        this.fieldNames.add("IPV6HeaderImpl_protocol");
        this.fieldNames.add("IPV6HeaderImpl_headerChecksum");
        this.fieldNames.add("IPV6HeaderImpl_options");
        this.fieldNames.add("IPV6HeaderImpl_padding");
        this.fieldNames.add("IPV6HeaderImpl_sourceAddress");
        this.fieldNames.add("IPV6HeaderImpl_destinationAddress");
        this.signalType = "Ipv6Header";
    }

    @Override
    public IPV6NextHeader getNextHeader() {
        return this.nextHeader;
    }

    @Override
    public void setNextHeader(IPV6NextHeader nextHeader) {
        this.nextHeader = nextHeader;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_nextHeader")) continue;
            this.fieldTable.set(i, new Pair<String, IPV6NextHeader>("IPV6HeaderImpl_nextHeader", nextHeader));
            return;
        }
    }

    @Override
    public Byte getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Byte version) {
        this.version = version;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_version")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("IPV6HeaderImpl_version", version));
            return;
        }
    }

    @Override
    public Byte getHeaderLength() {
        return this.headerLength;
    }

    @Override
    public void setHeaderLength(Byte headerLength) {
        this.headerLength = headerLength;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_headerLength")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("IPV6HeaderImpl_headerLength", headerLength));
            return;
        }
    }

    @Override
    public Byte getTypeOfService() {
        return this.typeOfService;
    }

    @Override
    public void setTypeOfService(Byte typeOfService) {
        this.typeOfService = typeOfService;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_typeOfService")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("IPV6HeaderImpl_typeOfService", typeOfService));
            return;
        }
    }

    @Override
    public Short getTotalLength() {
        return this.totalLength;
    }

    @Override
    public void setTotalLength(Short totalLength) {
        this.totalLength = totalLength;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_totalLength")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("IPV6HeaderImpl_totalLength", totalLength));
            return;
        }
    }

    @Override
    public Short getIdentification() {
        return this.identification;
    }

    @Override
    public void setIdentification(Short identification) {
        this.identification = identification;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_identification")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("IPV6HeaderImpl_identification", identification));
            return;
        }
    }

    @Override
    public Byte getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Byte flags) {
        this.flags = flags;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_flags")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("IPV6HeaderImpl_flags", flags));
            return;
        }
    }

    @Override
    public Short getFragmentOffset() {
        return this.fragmentOffset;
    }

    @Override
    public void setFragmentOffset(Short fragmentOffset) {
        this.fragmentOffset = fragmentOffset;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_fragmentOffset")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("IPV6HeaderImpl_fragmentOffset", fragmentOffset));
            return;
        }
    }

    @Override
    public Short getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(Short protocol) {
        this.protocol = protocol;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_protocol")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("IPV6HeaderImpl_protocol", protocol));
            return;
        }
    }

    @Override
    public Short getHeaderChecksum() {
        return this.headerChecksum;
    }

    @Override
    public void setHeaderChecksum(Short headerChecksum) {
        this.headerChecksum = headerChecksum;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_headerChecksum")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("IPV6HeaderImpl_headerChecksum", headerChecksum));
            return;
        }
    }

    @Override
    public int getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(int options) {
        this.options = options;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_options")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("IPV6HeaderImpl_options", options));
            return;
        }
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(int padding) {
        this.padding = padding;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_padding")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("IPV6HeaderImpl_padding", padding));
            return;
        }
    }

    @Override
    public IPV6Address getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    public void setSourceAddress(IPV6Address sourceAddress) {
        this.sourceAddress = sourceAddress;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_sourceAddress")) continue;
            this.fieldTable.set(i, new Pair<String, IPV6Address>("IPV6HeaderImpl_sourceAddress", sourceAddress));
            return;
        }
    }

    @Override
    public IPV6Address getDestinationAddress() {
        return this.destinationAddress;
    }

    @Override
    public void setDestinationAddress(IPV6Address destinationAddress) {
        this.destinationAddress = destinationAddress;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("IPV6HeaderImpl_destinationAddress")) continue;
            this.fieldTable.set(i, new Pair<String, IPV6Address>("IPV6HeaderImpl_destinationAddress", destinationAddress));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("IPV6HeaderImpl_nextHeader")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("IPV6HeaderImpl_version")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("IPV6HeaderImpl_headerLength")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("IPV6HeaderImpl_typeOfService")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("IPV6HeaderImpl_totalLength")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("IPV6HeaderImpl_identification")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("IPV6HeaderImpl_flags")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("IPV6HeaderImpl_fragmentOffset")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("IPV6HeaderImpl_protocol")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("IPV6HeaderImpl_headerChecksum")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("IPV6HeaderImpl_options")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("IPV6HeaderImpl_padding")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("IPV6HeaderImpl_sourceAddress")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("IPV6HeaderImpl_destinationAddress")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, IPV6NextHeader>("IPV6HeaderImpl_nextHeader", this.nextHeader));
        this.fieldTable.add(new Pair<String, Byte>("IPV6HeaderImpl_version", this.version));
        this.fieldTable.add(new Pair<String, Byte>("IPV6HeaderImpl_headerLength", this.headerLength));
        this.fieldTable.add(new Pair<String, Byte>("IPV6HeaderImpl_typeOfService", this.typeOfService));
        this.fieldTable.add(new Pair<String, Short>("IPV6HeaderImpl_totalLength", this.totalLength));
        this.fieldTable.add(new Pair<String, Short>("IPV6HeaderImpl_identification", this.identification));
        this.fieldTable.add(new Pair<String, Byte>("IPV6HeaderImpl_flags", this.flags));
        this.fieldTable.add(new Pair<String, Short>("IPV6HeaderImpl_fragmentOffset", this.fragmentOffset));
        this.fieldTable.add(new Pair<String, Short>("IPV6HeaderImpl_protocol", this.protocol));
        this.fieldTable.add(new Pair<String, Short>("IPV6HeaderImpl_headerChecksum", this.headerChecksum));
        this.fieldTable.add(new Pair<String, Integer>("IPV6HeaderImpl_options", this.options));
        this.fieldTable.add(new Pair<String, Integer>("IPV6HeaderImpl_padding", this.padding));
        this.fieldTable.add(new Pair<String, IPV6Address>("IPV6HeaderImpl_sourceAddress", this.sourceAddress));
        this.fieldTable.add(new Pair<String, IPV6Address>("IPV6HeaderImpl_destinationAddress", this.destinationAddress));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.nextHeader = (IPV6NextHeader)this.readIPCData(buffer);
        this.version = this.readByte(buffer);
        this.headerLength = this.readByte(buffer);
        this.typeOfService = this.readByte(buffer);
        this.totalLength = this.readShort(buffer);
        this.identification = this.readShort(buffer);
        this.flags = this.readByte(buffer);
        this.fragmentOffset = this.readShort(buffer);
        this.protocol = this.readShort(buffer);
        this.headerChecksum = this.readShort(buffer);
        this.options = this.readInt(buffer);
        this.padding = this.readInt(buffer);
        this.sourceAddress = this.readIPV6Address(buffer);
        this.destinationAddress = this.readIPV6Address(buffer);
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.nextHeader = (IPV6NextHeader)IPCResponseFactory.getPDUData(buffer);
        this.version = this.pduReadByte(buffer);
        this.headerLength = this.pduReadByte(buffer);
        this.typeOfService = this.pduReadByte(buffer);
        this.totalLength = this.pduReadShort(buffer);
        this.identification = this.pduReadShort(buffer);
        this.flags = this.pduReadByte(buffer);
        this.fragmentOffset = this.pduReadShort(buffer);
        this.protocol = this.pduReadShort(buffer);
        this.headerChecksum = this.pduReadShort(buffer);
        this.options = this.pduReadInt(buffer);
        this.padding = this.pduReadInt(buffer);
        this.sourceAddress = this.pduReadIPV6Address(buffer);
        this.destinationAddress = this.pduReadIPV6Address(buffer);
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        if (this.nextHeader == null) {
            buffer.putString("");
        } else {
            this.nextHeader.encodeTypeAndPayload(buffer);
        }
        buffer.putByte(this.version);
        buffer.putByte(this.headerLength);
        buffer.putByte(this.typeOfService);
        buffer.putShort(this.totalLength);
        buffer.putShort(this.identification);
        buffer.putByte(this.flags);
        buffer.putShort(this.fragmentOffset);
        buffer.putShort(this.protocol);
        buffer.putShort(this.headerChecksum);
        buffer.putInt(this.options);
        buffer.putInt(this.padding);
        buffer.putIPV6Address(this.sourceAddress);
        buffer.putIPV6Address(this.destinationAddress);
    }
}

