/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPV6Address;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.OSPFv6LinkLSA;
import com.cisco.pt.ipc.sim.pdu.OSPFv6OptionField;
import com.cisco.pt.ipc.sim.pdu.OSPFv6Prefix;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6LSAImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OSPFv6LinkLSAImpl
extends OSPFv6LSAImpl
implements OSPFv6LinkLSA {
    protected Byte routerPriority;
    protected OSPFv6OptionField option;
    protected IPV6Address linkLocalInterfaceAddress;
    protected List<OSPFv6Prefix> prefixes;

    public OSPFv6LinkLSAImpl() {
        this.fieldNames.add("OSPFv6LinkLSAImpl_routerPriority");
        this.fieldNames.add("OSPFv6LinkLSAImpl_option");
        this.fieldNames.add("OSPFv6LinkLSAImpl_linkLocalInterfaceAddress");
        this.fieldNames.add("OSPFv6LinkLSAImpl_prefixes");
        this.signalType = "Ospfv6LinkLSA";
    }

    @Override
    public Byte getRouterPriority() {
        return this.routerPriority;
    }

    @Override
    public void setRouterPriority(Byte routerPriority) {
        this.routerPriority = routerPriority;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6LinkLSAImpl_routerPriority")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("OSPFv6LinkLSAImpl_routerPriority", routerPriority));
            return;
        }
    }

    @Override
    public OSPFv6OptionField getOption() {
        return this.option;
    }

    @Override
    public void setOption(OSPFv6OptionField option) {
        this.option = option;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6LinkLSAImpl_option")) continue;
            this.fieldTable.set(i, new Pair<String, OSPFv6OptionField>("OSPFv6LinkLSAImpl_option", option));
            return;
        }
    }

    @Override
    public IPV6Address getLinkLocalInterfaceAddress() {
        return this.linkLocalInterfaceAddress;
    }

    @Override
    public void setLinkLocalInterfaceAddress(IPV6Address linkLocalInterfaceAddress) {
        this.linkLocalInterfaceAddress = linkLocalInterfaceAddress;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6LinkLSAImpl_linkLocalInterfaceAddress")) continue;
            this.fieldTable.set(i, new Pair<String, IPV6Address>("OSPFv6LinkLSAImpl_linkLocalInterfaceAddress", linkLocalInterfaceAddress));
            return;
        }
    }

    @Override
    public List<OSPFv6Prefix> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public void setPrefixes(List<OSPFv6Prefix> prefixes) {
        this.prefixes = prefixes;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6LinkLSAImpl_prefixes")) continue;
            this.fieldTable.set(i, new Pair<String, List<OSPFv6Prefix>>("OSPFv6LinkLSAImpl_prefixes", prefixes));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("OSPFv6LinkLSAImpl_routerPriority")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("OSPFv6LinkLSAImpl_option")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("OSPFv6LinkLSAImpl_linkLocalInterfaceAddress")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("OSPFv6LinkLSAImpl_prefixes")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Byte>("OSPFv6LinkLSAImpl_routerPriority", this.routerPriority));
        this.fieldTable.add(new Pair<String, OSPFv6OptionField>("OSPFv6LinkLSAImpl_option", this.option));
        this.fieldTable.add(new Pair<String, IPV6Address>("OSPFv6LinkLSAImpl_linkLocalInterfaceAddress", this.linkLocalInterfaceAddress));
        this.fieldTable.add(new Pair<String, List<OSPFv6Prefix>>("OSPFv6LinkLSAImpl_prefixes", this.prefixes));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.routerPriority = this.readByte(buffer);
        this.option = (OSPFv6OptionField)this.readIPCData(buffer);
        this.linkLocalInterfaceAddress = this.readIPV6Address(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.prefixes = new ArrayList<OSPFv6Prefix>();
        for (Object o : tempList1) {
            this.prefixes.add((OSPFv6Prefix)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.routerPriority = this.pduReadByte(buffer);
        this.option = (OSPFv6OptionField)IPCResponseFactory.getPDUData(buffer);
        this.linkLocalInterfaceAddress = this.pduReadIPV6Address(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)16);
        this.prefixes = new ArrayList<OSPFv6Prefix>();
        for (Object o : tempList1) {
            this.prefixes.add((OSPFv6Prefix)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putByte(this.routerPriority);
        if (this.option == null) {
            buffer.putString("");
        } else {
            this.option.encodeTypeAndPayload(buffer);
        }
        buffer.putIPV6Address(this.linkLocalInterfaceAddress);
        buffer.putInt(this.prefixes.size());
        for (OSPFv6Prefix item : this.prefixes) {
            item.encodeTypeAndPayload(buffer);
        }
    }
}

