/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.launcher;

import com.cisco.pt.launcher.PacketTracerLaunchException;
import com.cisco.pt.launcher.PacketTracerLauncher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MacPacketTracerLauncher
extends PacketTracerLauncher {
    protected MacPacketTracerLauncher(File homeDirectory) throws PacketTracerLaunchException {
        super(homeDirectory);
    }

    @Override
    protected String getExecutableString() {
        String execString = this.getHomeDirectory() + "/MacOS/" + this.getExecutableFullName();
        execString = execString.replace("\"", "");
        return execString;
    }

    @Override
    public File getSaveDirectory() {
        return new File(this.homeDirectory, "SAVES");
    }

    @Override
    public String getExecutableFullName() {
        return "PacketTracer";
    }

    @Override
    protected String getDefaultHome() {
        return "/Applications/Cisco Packet Tracer 8.1.0/Cisco Packet Tracer 8.1.app/Contents";
    }

    @Override
    protected String getPathVariable() {
        return "PATH";
    }

    @Override
    protected String getPathSeparator() {
        return ":";
    }

    @Override
    public String getPttpHome() {
        try {
            String path = this.getDefaultHome() + "/Resources";
            ArrayList<String> commandTokens = new ArrayList<String>();
            commandTokens.add(path + "/checkpttp");
            ProcessBuilder builder = new ProcessBuilder(commandTokens);
            Map<String, String> environment = builder.environment();
            environment.put(this.getPathVariable(), path);
            File homeDir = new File(this.getDefaultHome());
            builder = builder.directory(homeDir);
            builder = builder.redirectErrorStream(true);
            Process process = builder.start();
            PacketTracerLauncher.StreamReader reader = new PacketTracerLauncher.StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            String[] lines = output.split("\\r?\\n");
            output = lines[1] + "/Contents";
            return output;
        }
        catch (Exception e) {
            return ";";
        }
    }

    @Override
    protected List<String> getCommandTokens(int ipcPort, boolean noGui, File targetFile) throws Exception {
        ArrayList<String> commandTokens = new ArrayList<String>();
        commandTokens.add(this.getExecutableString());
        if (noGui) {
            commandTokens.add(this.wrapToken("--no-gui"));
        }
        if (ipcPort != 0) {
            commandTokens.add(this.wrapToken("--ipc-port"));
            commandTokens.add(this.wrapToken(String.valueOf(ipcPort)));
        }
        if (targetFile != null) {
            commandTokens.add(this.wrapToken(targetFile.getCanonicalPath()));
        }
        return commandTokens;
    }
}

