/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.launcher;

import com.cisco.pt.launcher.LinuxPacketTracerLauncher;
import com.cisco.pt.launcher.MacPacketTracerLauncher;
import com.cisco.pt.launcher.PacketTracerLaunchException;
import com.cisco.pt.launcher.WindowsPacketTracerLauncher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public abstract class PacketTracerLauncher {
    protected File homeDirectory;
    public static final int DEFAULT_IPC_PORT = 39000;
    public static final int NO_SPECIFIC_IPC_PORT = 0;

    protected PacketTracerLauncher(File homeDirectory) throws PacketTracerLaunchException {
        this.homeDirectory = homeDirectory == null ? this.findHomeDirectory() : homeDirectory;
    }

    public Process launch() throws PacketTracerLaunchException {
        return this.launch(0, false);
    }

    public Process launch(int ipcPort, boolean noGui) throws PacketTracerLaunchException {
        try {
            ProcessBuilder builder = new ProcessBuilder(this.getCommandTokens(ipcPort, noGui, null));
            File binDirectory = this.getBinDirectory();
            Map<String, String> environment = builder.environment();
            String path = environment.get(this.getPathVariable());
            if (path == null || path.trim().length() == 0) {
                environment.put(this.getPathVariable(), binDirectory.getCanonicalPath());
            } else {
                path = binDirectory.getCanonicalPath() + this.getPathSeparator() + path;
                environment.put(this.getPathVariable(), path);
            }
            File homeDir = this.findHomeDirectory();
            builder = builder.directory(homeDir);
            builder = builder.redirectErrorStream(true);
            return builder.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PacketTracerLaunchException(PacketTracerLaunchException.Reason.NotFound);
        }
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getBinDirectory() {
        return new File(this.homeDirectory, "bin");
    }

    public File getSaveDirectory() {
        return new File(this.homeDirectory, "saves");
    }

    protected String getPath() {
        return System.getenv(this.getPathVariable());
    }

    public abstract String getExecutableFullName();

    protected abstract String getDefaultHome();

    protected abstract String getPathVariable();

    protected abstract String getPathSeparator();

    public abstract String getPttpHome();

    protected abstract List<String> getCommandTokens(int var1, boolean var2, File var3) throws Exception;

    protected String getExecutableString() {
        return this.getBinDirectory() + "/" + this.getExecutableFullName();
    }

    protected String wrapToken(String commandToken) {
        return commandToken.indexOf(" ") >= 0 ? "\"" + commandToken + "\"" : commandToken;
    }

    public File findHomeDirectory() throws PacketTracerLaunchException {
        String[] pathDirs;
        File ptHome = this.homeDirectory;
        if (ptHome != null && ptHome.exists()) {
            return ptHome;
        }
        String path = this.getPath();
        for (String pathDir : pathDirs = path.split(this.getPathSeparator())) {
            File executable = new File(pathDir, this.getExecutableFullName());
            if (!executable.exists()) continue;
            ptHome = executable.getParentFile();
        }
        if (ptHome != null && ptHome.exists()) {
            return ptHome;
        }
        ptHome = new File(this.getPttpHome());
        if (ptHome.exists()) {
            return ptHome;
        }
        String ptHomeVariable = System.getenv("PT8HOME");
        if (ptHomeVariable != null && (ptHome = new File(ptHomeVariable)).exists()) {
            return ptHome;
        }
        String ptpath = this.getDefaultHome();
        ptHome = new File(ptpath);
        if (ptHome.exists()) {
            return ptHome;
        }
        ptHomeVariable = System.getenv("PT7HOME");
        if (ptHomeVariable != null && (ptHome = new File(ptHomeVariable)).exists()) {
            return ptHome;
        }
        ptHomeVariable = System.getenv("PT6HOME");
        if (ptHomeVariable != null && (ptHome = new File(ptHomeVariable)).exists()) {
            return ptHome;
        }
        ptHomeVariable = System.getenv("PT5HOME");
        if (ptHomeVariable != null && (ptHome = new File(ptHomeVariable)).exists()) {
            return ptHome;
        }
        ptHomeVariable = System.getenv("PTDIR");
        if (ptHomeVariable != null && (ptHome = new File(ptHomeVariable)).exists()) {
            return ptHome;
        }
        throw new PacketTracerLaunchException(PacketTracerLaunchException.Reason.NotFound, "Unable to find Packet Tracer installation directory.\n Launch PacketTracerLauncher.getInstance(homeDirectory) with the path to your Packet Tracer installation.");
    }

    public static PacketTracerLauncher getInstance(File homeDirectory) throws PacketTracerLaunchException {
        String osName = System.getProperty("os.name", "none").trim().toLowerCase();
        if (osName.equals("linux")) {
            return new LinuxPacketTracerLauncher(homeDirectory);
        }
        if (osName.startsWith("win")) {
            return new WindowsPacketTracerLauncher(homeDirectory);
        }
        if (osName.startsWith("mac")) {
            return new MacPacketTracerLauncher(homeDirectory);
        }
        throw new Error("No concrete PacketTracerLauncher subclass available for os.name = <" + System.getProperty("os.name") + ">");
    }

    public static PacketTracerLauncher getInstance() throws PacketTracerLaunchException {
        return PacketTracerLauncher.getInstance(null);
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }
}

