/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.launcher;

import com.cisco.pt.launcher.PacketTracerLaunchException;
import com.cisco.pt.launcher.PacketTracerLauncher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsPacketTracerLauncher
extends PacketTracerLauncher {
    protected WindowsPacketTracerLauncher(File homeDirectory) throws PacketTracerLaunchException {
        super(homeDirectory);
    }

    @Override
    public String getExecutableFullName() {
        return "PacketTracer.exe";
    }

    @Override
    protected String getDefaultHome() {
        return "C:/Program Files/Cisco Packet Tracer 8.1.0";
    }

    @Override
    protected String getPathVariable() {
        return "Path";
    }

    @Override
    protected String getPathSeparator() {
        return ";";
    }

    @Override
    public String getPttpHome() {
        String pttpHome = WindowsPacketTracerLauncher.readRegistry("HKLM\\SOFTWARE\\Classes\\pttp\\shell\\open\\command");
        if (pttpHome != null) {
            return pttpHome;
        }
        return ";";
    }

    public static final String readRegistry(String location) {
        try {
            Process process = Runtime.getRuntime().exec("reg query " + location);
            PacketTracerLauncher.StreamReader reader = new PacketTracerLauncher.StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            output = output.substring(output.indexOf("\"") + 1, output.indexOf("\\bin\\PacketTracer.exe"));
            return output;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected List<String> getCommandTokens(int ipcPort, boolean noGui, File targetFile) throws Exception {
        ArrayList<String> commandTokens = new ArrayList<String>();
        commandTokens.add(this.wrapToken(this.getExecutableString()));
        if (noGui) {
            commandTokens.add(this.wrapToken("--no-gui"));
        }
        if (ipcPort != 0) {
            commandTokens.add(this.wrapToken("--ipc-port"));
            commandTokens.add(this.wrapToken(String.valueOf(ipcPort)));
        }
        if (targetFile != null) {
            commandTokens.add(this.wrapToken(targetFile.getCanonicalPath()));
        }
        return commandTokens;
    }
}

