/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.filter.impl;

import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.filter.Filter;
import java.nio.ByteBuffer;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XorEncryptionFilter
implements Filter {
    private static Log logger = LogFactory.getLog(XorEncryptionFilter.class);
    private static final String NONHEX_REGEX = "[^0-9a-f]";
    private byte[] key = new byte[]{0};

    public XorEncryptionFilter(ConnectionNegotiationProperties connectionNegotiationProperties) {
        if (connectionNegotiationProperties != null) {
            String serverUid = connectionNegotiationProperties.getServerUid();
            String clientUid = connectionNegotiationProperties.getClientUid();
            String serverStamp = connectionNegotiationProperties.getServerTimestamp();
            String clientStamp = connectionNegotiationProperties.getClientTimestamp();
            if (serverUid != null && clientUid != null && serverStamp != null && clientStamp != null) {
                ByteBuffer keyBuff = ByteBuffer.allocate(2048);
                Hex encoder = new Hex();
                try {
                    serverUid = serverUid.replaceAll(NONHEX_REGEX, "");
                    clientUid = clientUid.replaceAll(NONHEX_REGEX, "");
                    byte[] serverUidBytes = encoder.decode(serverUid.getBytes());
                    byte[] clientUidBytes = encoder.decode(clientUid.getBytes());
                    keyBuff.put(serverUidBytes);
                    keyBuff.put(clientUidBytes);
                    keyBuff.put("PTMP".getBytes());
                    keyBuff.put(serverStamp.getBytes());
                    keyBuff.put(clientStamp.getBytes());
                    this.key = new byte[keyBuff.position()];
                    keyBuff.flip();
                    keyBuff.get(this.key);
                }
                catch (PatternSyntaxException pse) {
                    logger.error((Object)pse.getMessage());
                }
                catch (DecoderException de) {
                    logger.error((Object)("Error decoding encryption key field: " + de.getMessage()));
                }
            } else {
                logger.warn((Object)"Required encryption key field is empty.");
            }
        } else {
            logger.warn((Object)"ConnectionNegotiationProperties is empty.");
        }
    }

    @Override
    public byte[] in(byte[] bytes) {
        return this.xorBytes(bytes);
    }

    @Override
    public byte[] out(byte[] bytes) {
        return this.xorBytes(bytes);
    }

    private byte[] xorBytes(byte[] bytes) {
        byte[] xorBytes = null;
        int keySize = this.key.length;
        if (bytes != null) {
            xorBytes = new byte[bytes.length];
            int index = 0;
            for (byte b : bytes) {
                xorBytes[index] = (byte)(b ^ this.key[index % keySize]);
                ++index;
            }
        }
        return xorBytes;
    }
}

