/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.task;

import com.cisco.pt.LTV;
import com.cisco.pt.impl.AuthChallengeLTV;
import com.cisco.pt.impl.AuthRequestLTV;
import com.cisco.pt.impl.AuthResponseLTV;
import com.cisco.pt.impl.AuthStatusLTV;
import com.cisco.pt.impl.BooleanValue;
import com.cisco.pt.impl.StringValue;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationTask {
    private static Log logger = LogFactory.getLog(AuthenticationTask.class);
    private PacketTracerSession packetTracerSession;
    private String app_id = "";
    private String shared_secret = "";
    private int auth_type;

    public AuthenticationTask(PacketTracerSession packetTracerSession) {
        this.packetTracerSession = packetTracerSession;
        this.app_id = packetTracerSession.connection().connectionNegotiationProperties().getAuthenticationApplication();
        this.shared_secret = packetTracerSession.connection().connectionNegotiationProperties().getAuthenticationSecret();
        this.auth_type = packetTracerSession.connection().connectionNegotiationProperties().getAuthentication();
    }

    public boolean authenticate() throws IOException {
        AuthRequestLTV authReqLTV = new AuthRequestLTV(new StringValue(this.app_id));
        AuthChallengeLTV authChallengeLTV = (AuthChallengeLTV)this.packetTracerSession.writeRead(authReqLTV);
        String challenge = ((StringValue)authChallengeLTV.getValue()).value();
        boolean status = false;
        String logMessage = "Authentication error";
        String digest = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Received auth challenge from server: [" + challenge + "]"));
        }
        AuthResponseLTV authRespLTV = null;
        LTV returnLTV = null;
        switch (this.auth_type) {
            case 1: {
                digest = this.shared_secret;
                break;
            }
            case 2: {
                digest = AuthenticationTask.generateSimpleHash(this.shared_secret);
                break;
            }
            case 4: {
                digest = AuthenticationTask.generateCrypt(challenge, this.shared_secret);
                break;
            }
            default: {
                logMessage = "Unknown authentication method.";
            }
        }
        authRespLTV = new AuthResponseLTV(this.app_id, digest);
        returnLTV = this.packetTracerSession.writeRead(authRespLTV);
        if (returnLTV != null) {
            switch (returnLTV.getType()) {
                case 7: {
                    logMessage = "Authentication terminated by disconnect";
                    break;
                }
                case 5: {
                    BooleanValue bv = (BooleanValue)((AuthStatusLTV)returnLTV).getValue();
                    status = bv.value();
                    logMessage = "Authentication status: " + status;
                    break;
                }
                default: {
                    logMessage = "Unknown return type from authentication request";
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)logMessage);
        }
        return status;
    }

    private static byte[] generateBinaryCrypt(String data, String shared_secret) {
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data.getBytes());
            md.update(shared_secret.getBytes());
            result = md.digest();
        }
        catch (Exception x) {
            logger.error((Object)x.getMessage(), (Throwable)x);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Generated MD5: [" + result + "]"));
        }
        return result;
    }

    private static String generateCrypt(String data, String shared_secret) {
        char[] chars;
        String md5HexStr = null;
        byte[] result = AuthenticationTask.generateBinaryCrypt(data, shared_secret);
        if (result != null && result.length == 16 && (chars = Hex.encodeHex((byte[])result)).length == 32) {
            md5HexStr = new String(chars).toUpperCase();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Generated MD5 string: [" + md5HexStr + "]"));
        }
        return md5HexStr;
    }

    private static String generateSimpleHash(String data) {
        StringBuffer hashStr = new StringBuffer();
        byte[] dataBytes = data.getBytes();
        if (dataBytes != null) {
            for (byte dataByte : dataBytes) {
                hashStr.append((char)(158 - dataByte));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Generated hash string: [" + hashStr.toString() + "]"));
        }
        return hashStr.toString();
    }
}

