/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.util;

import com.cisco.pt.EncodedBuffer;

public class Utilities {
    public static void check(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
    }

    public static String dumpRawBytes(EncodedBuffer buffer) {
        return Utilities.dumpRawBytes(buffer, true);
    }

    public static String dumpRawBytes(EncodedBuffer buffer, boolean shouldFlip) {
        StringBuilder builder = new StringBuilder();
        byte[] bytes = buffer.copyRawBytes(shouldFlip);
        for (int i = 0; i < bytes.length; ++i) {
            builder.append(Utilities.rightJustify(i, 5));
            builder.append("  ");
            builder.append(Utilities.rightJustify(bytes[i], 3));
            builder.append("  <");
            builder.append(Character.valueOf((char)bytes[i]));
            builder.append(">\n");
        }
        return builder.toString();
    }

    public static String dumpRawBytes(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            builder.append(Utilities.rightJustify(i, 5));
            builder.append("  ");
            builder.append(Utilities.rightJustify(bytes[i], 3));
            builder.append("  <");
            builder.append(Character.valueOf((char)bytes[i]));
            builder.append(">\n");
        }
        return builder.toString();
    }

    public static String rightJustify(int i, int length) {
        String answer = String.valueOf(i);
        while (answer.length() < length) {
            answer = " " + answer;
        }
        return answer;
    }
}

