/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.LTVParsingError;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MACAddressImpl
implements MACAddress {
    private static Log logger = LogFactory.getLog(MACAddressImpl.class);
    private static final int HEX_RADIX = 16;
    public static final int MACADDRESS_BYTES = 6;
    byte[] bytes = new byte[6];

    public MACAddressImpl(byte[] newBytes) {
        this.setBytes(newBytes);
    }

    public MACAddressImpl(String dottedHexStr) throws NumberFormatException {
        try {
            dottedHexStr = dottedHexStr.replaceAll("\\:", "");
            dottedHexStr = dottedHexStr.replaceAll("\\.", "");
            this.setBytes(Hex.decodeHex((char[])dottedHexStr.toCharArray()));
        }
        catch (DecoderException de) {
            logger.error((Object)("Error decoding dotted hex string: " + de.getMessage()));
            throw (NumberFormatException)new NumberFormatException("Invalid MAC address specified: " + dottedHexStr).initCause(de);
        }
    }

    protected void setBytes(byte[] newBytes) {
        Arrays.fill(this.bytes, (byte)0);
        int offset = newBytes.length >= this.bytes.length ? 0 : this.bytes.length - newBytes.length;
        int limit = Math.min(this.bytes.length, newBytes.length);
        for (int i = 0; i < limit; ++i) {
            this.bytes[offset + i] = newBytes[i];
        }
    }

    @Override
    public String getDottedHexString() {
        StringBuilder builder = new StringBuilder();
        char[] chars = Hex.encodeHex((byte[])this.bytes);
        for (int i = 0; i < chars.length; ++i) {
            builder.append(chars[i]);
            if (i % 4 != 3 || i >= chars.length - 1) continue;
            builder.append('.');
        }
        return builder.toString();
    }

    @Override
    public String getHexString() {
        char[] chars = Hex.encodeHex((byte[])this.bytes);
        return new String(chars);
    }

    public static MACAddress parseMACAddress(String s) {
        MACAddressImpl macAddr = null;
        String[] triadStrings = s.split("\\.");
        if (triadStrings.length != 3) {
            throw new LTVParsingError("Invalid format for MAC Address: " + s);
        }
        try {
            byte[] parseBytes = new byte[6];
            for (int index = 0; index < triadStrings.length; ++index) {
                int triad = Integer.parseInt(triadStrings[index], 16);
                parseBytes[2 * index] = (byte)(triad >> 8 & 0xFF);
                parseBytes[2 * index + 1] = (byte)(triad & 0xFF);
            }
            macAddr = new MACAddressImpl(parseBytes);
        }
        catch (NumberFormatException nfe) {
            throw new LTVParsingError("Invalid format for MAC Address: " + s);
        }
        return macAddr;
    }

    @Override
    public byte[] getByteArrayValue() {
        return this.bytes;
    }
}

