/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class BluetoothManagerEvent
extends IPCEvent {
    public EventType type;

    public BluetoothManagerEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        DEVICE_DISCOVERED,
        DEVICE_PAIRED,
        DEVICE_UNPAIRED,
        DEVICE_CONNECTED,
        DEVICE_DISCONNECTED;

    }

    public static class DeviceDisconnected
    extends BluetoothManagerEvent {
        public MACAddress macAddress;

        public DeviceDisconnected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_DISCONNECTED;
            this.macAddress = (MACAddress)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tmacAddress = " + this.macAddress;
        }
    }

    public static class DeviceConnected
    extends BluetoothManagerEvent {
        public MACAddress macAddress;

        public DeviceConnected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_CONNECTED;
            this.macAddress = (MACAddress)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tmacAddress = " + this.macAddress;
        }
    }

    public static class DeviceUnpaired
    extends BluetoothManagerEvent {
        public MACAddress macAddress;

        public DeviceUnpaired(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_UNPAIRED;
            this.macAddress = (MACAddress)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tmacAddress = " + this.macAddress;
        }
    }

    public static class DevicePaired
    extends BluetoothManagerEvent {
        public MACAddress macAddress;

        public DevicePaired(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_PAIRED;
            this.macAddress = (MACAddress)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tmacAddress = " + this.macAddress;
        }
    }

    public static class DeviceDiscovered
    extends BluetoothManagerEvent {
        public MACAddress macAddress;
        public String deviceName;

        public DeviceDiscovered(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DEVICE_DISCOVERED;
            this.macAddress = (MACAddress)ltv.getEventParameters().get(0);
            this.deviceName = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tmacAddress = " + this.macAddress + "\n\tdeviceName = " + this.deviceName;
        }
    }
}

