/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.LoginMethod;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class CiscoDeviceEvent
extends IPCEvent {
    public EventType type;

    public CiscoDeviceEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        DONE_BOOTING,
        LINE_CONNECTED,
        LINE_DISCONNECTED,
        LINE_AUTHENTICATION_STARTED,
        LINE_AUTHENTICATION_FAILED,
        LINE_AUTHENTICATION_FINISHED,
        CLOSE_TABLE_EVENT;

    }

    public static class CloseTableEvent
    extends CiscoDeviceEvent {
        public CloseTableEvent(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.CLOSE_TABLE_EVENT;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class LineAuthenticationFinished
    extends CiscoDeviceEvent {
        public int lineNum;
        public Boolean success;

        public LineAuthenticationFinished(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_AUTHENTICATION_FINISHED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
            this.success = (Boolean)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsuccess = " + this.success;
        }
    }

    public static class LineAuthenticationFailed
    extends CiscoDeviceEvent {
        public int lineNum;

        public LineAuthenticationFailed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_AUTHENTICATION_FAILED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum;
        }
    }

    public static class LineAuthenticationStarted
    extends CiscoDeviceEvent {
        public int lineNum;
        public IPAddress srcIp;
        public Short srcTcpPort;
        public LoginMethod loginMethod;

        public LineAuthenticationStarted(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_AUTHENTICATION_STARTED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
            this.srcIp = (IPAddress)ltv.getEventParameters().get(1);
            this.srcTcpPort = (Short)ltv.getEventParameters().get(2);
            this.loginMethod = LoginMethod.fromIntValue((Integer)ltv.getEventParameters().get(3));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsrcIp = " + this.srcIp + "\n\tsrcTcpPort = " + this.srcTcpPort + "\n\tloginMethod = " + (Object)((Object)this.loginMethod);
        }
    }

    public static class LineDisconnected
    extends CiscoDeviceEvent {
        public int lineNum;

        public LineDisconnected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_DISCONNECTED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum;
        }
    }

    public static class LineConnected
    extends CiscoDeviceEvent {
        public int lineNum;
        public IPAddress srcIp;
        public Short srcTcpPort;
        public LoginMethod loginMethod;

        public LineConnected(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LINE_CONNECTED;
            this.lineNum = (Integer)ltv.getEventParameters().get(0);
            this.srcIp = (IPAddress)ltv.getEventParameters().get(1);
            this.srcTcpPort = (Short)ltv.getEventParameters().get(2);
            this.loginMethod = LoginMethod.fromIntValue((Integer)ltv.getEventParameters().get(3));
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsrcIp = " + this.srcIp + "\n\tsrcTcpPort = " + this.srcTcpPort + "\n\tloginMethod = " + (Object)((Object)this.loginMethod);
        }
    }

    public static class DoneBooting
    extends CiscoDeviceEvent {
        public DoneBooting(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DONE_BOOTING;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }
}

