/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.ClusterEvent;
import com.cisco.pt.ipc.events.ClusterEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.Cluster;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterEventRegistry
extends IPCEventRegistry {
    protected Set<ClusterEventListener> globalListeners = new HashSet<ClusterEventListener>();
    protected Map<String, Set<ClusterEventListener>> specificObjectListeners = new HashMap<String, Set<ClusterEventListener>>();
    private static Log logger = LogFactory.getLog(ClusterEventRegistry.class);

    public ClusterEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Cluster";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        ClusterEvent evt = null;
        if (eventName.equalsIgnoreCase("nameChanged")) {
            evt = new ClusterEvent.NameChanged(event);
        } else if (eventName.equalsIgnoreCase("idChanged")) {
            evt = new ClusterEvent.IdChanged(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (ClusterEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<ClusterEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (ClusterEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(ClusterEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("nameChanged");
                this.register("idChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(ClusterEventListener listener, Cluster objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ClusterEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<ClusterEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "nameChanged");
                this.register(uuid, "idChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(ClusterEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("nameChanged");
                this.deregister("idChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(ClusterEventListener listener, Cluster objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<ClusterEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "nameChanged");
            this.deregister(uuid, "idChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(ClusterEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(ClusterEventListener listener, Cluster objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(ClusterEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(ClusterEventListener listener, Cluster objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

