/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.DeviceDialogEvent;
import com.cisco.pt.ipc.events.DeviceDialogEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.ui.DeviceDialog;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeviceDialogEventRegistry
extends IPCEventRegistry {
    protected Set<DeviceDialogEventListener> globalListeners = new HashSet<DeviceDialogEventListener>();
    protected Map<String, Set<DeviceDialogEventListener>> specificObjectListeners = new HashMap<String, Set<DeviceDialogEventListener>>();
    private static Log logger = LogFactory.getLog(DeviceDialogEventRegistry.class);

    public DeviceDialogEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "DeviceDialog";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        DeviceDialogEvent evt = null;
        if (eventName.equalsIgnoreCase("desktopAppOpened")) {
            evt = new DeviceDialogEvent.DesktopAppOpened(event);
        } else if (eventName.equalsIgnoreCase("tabChanged")) {
            evt = new DeviceDialogEvent.TabChanged(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (DeviceDialogEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<DeviceDialogEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (DeviceDialogEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(DeviceDialogEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("desktopAppOpened");
                this.register("tabChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(DeviceDialogEventListener listener, DeviceDialog objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DeviceDialogEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<DeviceDialogEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "desktopAppOpened");
                this.register(uuid, "tabChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(DeviceDialogEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("desktopAppOpened");
                this.deregister("tabChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(DeviceDialogEventListener listener, DeviceDialog objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DeviceDialogEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "desktopAppOpened");
            this.deregister(uuid, "tabChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(DeviceDialogEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(DeviceDialogEventListener listener, DeviceDialog objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(DeviceDialogEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(DeviceDialogEventListener listener, DeviceDialog objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

