/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class DirectoryEvent
extends IPCEvent {
    public EventType type;

    public DirectoryEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        FILE_ADDED,
        FILE_REMOVED,
        FILE_RENAMED;

    }

    public static class FileRenamed
    extends DirectoryEvent {
        public String oldFileName;
        public String newFileName;

        public FileRenamed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_RENAMED;
            this.oldFileName = (String)ltv.getEventParameters().get(0);
            this.newFileName = (String)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\toldFileName = " + this.oldFileName + "\n\tnewFileName = " + this.newFileName;
        }
    }

    public static class FileRemoved
    extends DirectoryEvent {
        public String fileName;

        public FileRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_REMOVED;
            this.fileName = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tfileName = " + this.fileName;
        }
    }

    public static class FileAdded
    extends DirectoryEvent {
        public String fileName;

        public FileAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_ADDED;
            this.fileName = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tfileName = " + this.fileName;
        }
    }
}

