/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.GeoViewEvent;
import com.cisco.pt.ipc.events.GeoViewEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.ui.GeoView;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeoViewEventRegistry
extends IPCEventRegistry {
    protected Set<GeoViewEventListener> globalListeners = new HashSet<GeoViewEventListener>();
    protected Map<String, Set<GeoViewEventListener>> specificObjectListeners = new HashMap<String, Set<GeoViewEventListener>>();
    private static Log logger = LogFactory.getLog(GeoViewEventRegistry.class);

    public GeoViewEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "GeoView";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        GeoViewEvent evt = null;
        if (eventName.equalsIgnoreCase("linkStarted")) {
            evt = new GeoViewEvent.LinkStarted(event);
        } else if (eventName.equalsIgnoreCase("linkCreated")) {
            evt = new GeoViewEvent.LinkCreated(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (GeoViewEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<GeoViewEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (GeoViewEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(GeoViewEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("linkStarted");
                this.register("linkCreated");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(GeoViewEventListener listener, GeoView objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<GeoViewEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<GeoViewEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "linkStarted");
                this.register(uuid, "linkCreated");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(GeoViewEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("linkStarted");
                this.deregister("linkCreated");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(GeoViewEventListener listener, GeoView objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<GeoViewEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "linkStarted");
            this.deregister(uuid, "linkCreated");
            specificListeners.remove(listener);
        }
    }

    public void addListener(GeoViewEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(GeoViewEventListener listener, GeoView objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(GeoViewEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(GeoViewEventListener listener, GeoView objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

