/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.impl.IPCEventSubscriptionLTV;
import com.cisco.pt.impl.UUIDImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;

public abstract class IPCEventRegistry {
    protected PacketTracerSession session;
    public static final UUID WILDCARD_UUID = new UUIDImpl((String)null);

    public IPCEventRegistry(PacketTracerSession session) {
        this.session = session;
    }

    public abstract String getClassName();

    public abstract void processEvent(IPCEventLTV var1) throws Exception;

    protected void register(String eventName) throws IOException {
        IPCEventSubscriptionLTV ltv = new IPCEventSubscriptionLTV(this.getClassName(), WILDCARD_UUID, eventName, true);
        this.session.write(ltv);
    }

    protected void deregister(String eventName) throws IOException {
        IPCEventSubscriptionLTV ltv = new IPCEventSubscriptionLTV(this.getClassName(), WILDCARD_UUID, eventName, false);
        this.session.write(ltv);
    }

    protected void register(UUID uuid, String eventName) throws IOException {
        IPCEventSubscriptionLTV ltv = new IPCEventSubscriptionLTV(this.getClassName(), uuid, eventName, true);
        this.session.write(ltv);
    }

    protected void deregister(UUID uuid, String eventName) throws IOException {
        IPCEventSubscriptionLTV ltv = new IPCEventSubscriptionLTV(this.getClassName(), uuid, eventName, false);
        this.session.write(ltv);
    }
}

