/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class InstructionDlgEvent
extends IPCEvent {
    public EventType type;

    public InstructionDlgEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    public static enum EventType {
        DOCK_CHANGED,
        COUNTDOWN_EXPIRED,
        BUTTON_CLICKED,
        SLIDER_VALUE_CHANGED;

    }

    public static class SliderValueChanged
    extends InstructionDlgEvent {
        public String name;
        public int value;

        public SliderValueChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.SLIDER_VALUE_CHANGED;
            this.name = (String)ltv.getEventParameters().get(0);
            this.value = (Integer)ltv.getEventParameters().get(1);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tname = " + this.name + "\n\tvalue = " + this.value;
        }
    }

    public static class ButtonClicked
    extends InstructionDlgEvent {
        public String name;

        public ButtonClicked(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.BUTTON_CLICKED;
            this.name = (String)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tname = " + this.name;
        }
    }

    public static class CountdownExpired
    extends InstructionDlgEvent {
        public CountdownExpired(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.COUNTDOWN_EXPIRED;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class DockChanged
    extends InstructionDlgEvent {
        public Boolean isDocked;

        public DockChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DOCK_CHANGED;
            this.isDocked = (Boolean)ltv.getEventParameters().get(0);
        }

        @Override
        public String toString() {
            return super.toString() + "\n\tisDocked = " + this.isDocked;
        }
    }
}

